/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea;

import com.intellij.openapi.options.ConfigurableBase;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.HgGlobalSettings;
import org.zmlx.hg4idea.HgProjectSettings;
import org.zmlx.hg4idea.ui.HgConfigurationProjectPanel;

public final class HgProjectConfigurable
extends ConfigurableBase<HgConfigurationProjectPanel, HgSettingsHolder> {
    @NotNull
    private final Project myProject;
    @NotNull
    private final HgSettingsHolder mySettingsHolder;

    public HgProjectConfigurable(@NotNull Project project) {
        super("vcs.Mercurial", HgProjectConfigurable.getDISPLAY_NAME(), "project.propVCSSupport.VCSs.Mercurial");
        this.myProject = project;
        this.mySettingsHolder = new HgSettingsHolder(HgGlobalSettings.getInstance(), HgProjectSettings.getInstance(this.myProject));
    }

    @NotNull
    protected HgSettingsHolder getSettings() {
        return this.mySettingsHolder;
    }

    protected HgConfigurationProjectPanel createUi() {
        return new HgConfigurationProjectPanel(this.myProject);
    }

    public static String getDISPLAY_NAME() {
        return HgBundle.message("hg4idea.mercurial", new Object[0]);
    }

    public static final class HgSettingsHolder {
        @NotNull
        private final HgGlobalSettings myGlobalSettings;
        @NotNull
        private final HgProjectSettings myProjectSettings;

        HgSettingsHolder(@NotNull HgGlobalSettings globalSettings, @NotNull HgProjectSettings projectSettings) {
            this.myGlobalSettings = globalSettings;
            this.myProjectSettings = projectSettings;
        }

        @NotNull
        public HgGlobalSettings getGlobalSettings() {
            return this.myGlobalSettings;
        }

        @NotNull
        public HgProjectSettings getProjectSettings() {
            return this.myProjectSettings;
        }
    }
}

