/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.options.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.intellij.images.options.EditorOptions;
import org.intellij.images.options.ExternalEditorOptions;
import org.intellij.images.options.Options;
import org.intellij.images.options.impl.EditorOptionsImpl;
import org.intellij.images.options.impl.ExternalEditorOptionsImpl;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

final class OptionsImpl
implements Options,
JDOMExternalizable {
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private final EditorOptions editorOptions = new EditorOptionsImpl(this.propertyChangeSupport);
    private final ExternalEditorOptions externalEditorOptions = new ExternalEditorOptionsImpl(this.propertyChangeSupport);

    OptionsImpl() {
    }

    @Override
    @NotNull
    public EditorOptions getEditorOptions() {
        return this.editorOptions;
    }

    @Override
    @NotNull
    public ExternalEditorOptions getExternalEditorOptions() {
        return this.externalEditorOptions;
    }

    @Override
    public void inject(@NotNull Options options) {
        this.editorOptions.inject(options.getEditorOptions());
        this.externalEditorOptions.inject(options.getExternalEditorOptions());
    }

    @Override
    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener, @NotNull Disposable parent) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
        Disposer.register((Disposable)parent, () -> this.propertyChangeSupport.removePropertyChangeListener(listener));
    }

    @Override
    public boolean setOption(@NotNull String name, Object value) {
        return this.editorOptions.setOption(name, value) || this.externalEditorOptions.setOption(name, value);
    }

    public void readExternal(Element element) throws InvalidDataException {
        ((JDOMExternalizable)this.editorOptions).readExternal(element);
        ((JDOMExternalizable)this.externalEditorOptions).readExternal(element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        ((JDOMExternalizable)this.editorOptions).writeExternal(element);
        ((JDOMExternalizable)this.externalEditorOptions).writeExternal(element);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Options)) {
            return false;
        }
        Options otherOptions = (Options)obj;
        EditorOptions editorOptions = otherOptions.getEditorOptions();
        ExternalEditorOptions externalEditorOptions = otherOptions.getExternalEditorOptions();
        return editorOptions.equals(this.getEditorOptions()) && externalEditorOptions.equals(this.getExternalEditorOptions());
    }

    public int hashCode() {
        int result = this.editorOptions.hashCode();
        result = 29 * result + this.externalEditorOptions.hashCode();
        return result;
    }
}

