/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.editor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import java.awt.Color;
import javax.swing.JComponent;
import org.intellij.images.editor.ImageDocument;
import org.intellij.images.editor.ImageEditor;
import org.intellij.images.editor.ImageZoomModel;
import org.intellij.images.editor.impl.ImageEditorUI;
import org.intellij.images.fileTypes.ImageFileTypeManager;
import org.intellij.images.vfs.IfsUtil;
import org.jetbrains.annotations.NotNull;

public final class ImageEditorImpl
implements ImageEditor {
    private final Project project;
    private final VirtualFile file;
    private final ImageEditorUI editorUI;
    private boolean disposed;

    public ImageEditorImpl(@NotNull Project project, @NotNull VirtualFile file) {
        this(project, file, false);
    }

    public ImageEditorImpl(@NotNull Project project, @NotNull VirtualFile file, boolean isEmbedded) {
        this.project = project;
        this.file = file;
        this.editorUI = new ImageEditorUI(this, isEmbedded);
        Disposer.register((Disposable)this, (Disposable)this.editorUI);
        VirtualFileManager.getInstance().addVirtualFileListener(new VirtualFileListener(){

            public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
                ImageEditorImpl.this.propertyChanged(event);
            }

            public void contentsChanged(@NotNull VirtualFileEvent event) {
                ImageEditorImpl.this.contentsChanged(event);
            }
        }, (Disposable)this);
        this.setValue(file);
    }

    void setValue(VirtualFile file) {
        try {
            this.editorUI.setImageProvider(IfsUtil.getImageProvider(file), IfsUtil.getFormat(file));
        }
        catch (Exception e) {
            this.editorUI.setImageProvider(null, null);
        }
    }

    @Override
    public boolean isValid() {
        ImageDocument document = this.editorUI.getImageComponent().getDocument();
        return document.getValue() != null;
    }

    @Override
    public ImageEditorUI getComponent() {
        return this.editorUI;
    }

    @Override
    public JComponent getContentComponent() {
        return this.editorUI.getImageComponent();
    }

    @Override
    @NotNull
    public VirtualFile getFile() {
        return this.file;
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Override
    public ImageDocument getDocument() {
        return this.editorUI.getImageComponent().getDocument();
    }

    @Override
    public void setTransparencyChessboardVisible(boolean visible) {
        this.editorUI.getImageComponent().setTransparencyChessboardVisible(visible);
        this.editorUI.repaint();
    }

    @Override
    public boolean isTransparencyChessboardVisible() {
        return this.editorUI.getImageComponent().isTransparencyChessboardVisible();
    }

    @Override
    public boolean isEnabledForActionPlace(String place) {
        return !"Images.Thumbnails".equals(place);
    }

    @Override
    public void setGridVisible(boolean visible) {
        this.editorUI.getImageComponent().setGridVisible(visible);
        this.editorUI.repaint();
    }

    @Override
    public void setEditorBackground(Color color) {
        this.editorUI.getImageComponent().getParent().setBackground(color);
    }

    @Override
    public void setBorderVisible(boolean visible) {
        this.editorUI.getImageComponent().setBorderVisible(visible);
    }

    @Override
    public boolean isGridVisible() {
        return this.editorUI.getImageComponent().isGridVisible();
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public ImageZoomModel getZoomModel() {
        return this.editorUI.getZoomModel();
    }

    public void dispose() {
        this.disposed = true;
    }

    void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
        if (this.file.equals(event.getFile())) {
            this.file.refresh(true, false, () -> {
                if (ImageFileTypeManager.getInstance().isImage(this.file)) {
                    this.setValue(this.file);
                } else {
                    this.setValue(null);
                    FileEditorManager editorManager = FileEditorManager.getInstance((Project)this.project);
                    editorManager.closeFile(this.file);
                }
            });
        }
    }

    void contentsChanged(@NotNull VirtualFileEvent event) {
        if (this.file.equals(event.getFile())) {
            Runnable postRunnable = () -> this.setValue(this.file);
            RefreshQueue.getInstance().refresh(true, false, postRunnable, ModalityState.current(), new VirtualFile[]{this.file});
        }
    }
}

