/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.editor.actions;

import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.intellij.images.editor.actions.BackgroundImageDialog;
import org.intellij.images.fileTypes.ImageFileTypeManager;
import org.jetbrains.annotations.NotNull;

public class SetBackgroundImageAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        boolean image = file != null && ImageFileTypeManager.getInstance().isImage(file);
        boolean visible = !ActionPlaces.isPopupPlace((String)e.getPlace()) || image;
        e.getPresentation().setEnabled(project != null);
        e.getPresentation().setVisible(visible);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        boolean image = file != null && ImageFileTypeManager.getInstance().isImage(file);
        BackgroundImageDialog dialog = new BackgroundImageDialog(project, image ? file.getPath() : null);
        dialog.showAndGet();
    }
}

