/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.editor.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import org.intellij.images.editor.ImageZoomModel;
import org.intellij.images.editor.actionSystem.ImageEditorActionUtil;
import org.intellij.images.options.Options;
import org.intellij.images.options.OptionsManager;
import org.intellij.images.options.ZoomOptions;
import org.intellij.images.ui.ImageComponentDecorator;
import org.jetbrains.annotations.NotNull;

final class FitZoomToWindowAction
extends AnAction
implements DumbAware {
    FitZoomToWindowAction() {
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        ImageComponentDecorator decorator = ImageEditorActionUtil.getImageComponentDecorator(e);
        if (decorator != null) {
            ImageZoomModel zoomModel = decorator.getZoomModel();
            zoomModel.fitZoomToWindow();
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (ImageEditorActionUtil.setEnabled(e)) {
            Options options = OptionsManager.getInstance().getOptions();
            ZoomOptions zoomOptions = options.getEditorOptions().getZoomOptions();
            ImageComponentDecorator decorator = ImageEditorActionUtil.getImageComponentDecorator(e);
            ImageZoomModel zoomModel = decorator.getZoomModel();
            e.getPresentation().setEnabled(zoomModel.isZoomLevelChanged() || !zoomOptions.isSmartZooming());
        }
    }
}

