/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.editor.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ColorPicker;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.picker.ColorListener;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import org.intellij.images.editor.actionSystem.ImageEditorActionUtil;
import org.intellij.images.ui.ImageComponentDecorator;
import org.jetbrains.annotations.NotNull;

public class ChangeBackgroundAction
extends DumbAwareAction {
    private final MyBackgroundIcon myIcon = new MyBackgroundIcon();

    public ChangeBackgroundAction() {
        this.getTemplatePresentation().setIcon((Icon)this.myIcon);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        final Component component = e.getInputEvent().getComponent();
        final ImageComponentDecorator decorator = ImageEditorActionUtil.getImageComponentDecorator(e);
        if (component != null && decorator != null) {
            ColorPicker.showColorPickerPopup((Project)e.getProject(), null, null, (ColorListener)new ColorListener(){

                public void colorChanged(Color color, Object source) {
                    ((ChangeBackgroundAction)ChangeBackgroundAction.this).myIcon.color = color;
                    component.repaint();
                    decorator.setEditorBackground(color);
                }
            });
        }
    }

    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabledAndVisible(Registry.is((String)"ide.images.change.background.action.enabled", (boolean)false));
    }

    private static class MyBackgroundIcon
    implements Icon {
        Color color = JBColor.background();

        private MyBackgroundIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
            g.setColor(this.color);
            g.fillOval(x + 1, y + 1, 14, 14);
            g.setColor(ColorUtil.isDark((Color)this.color) ? Gray.xFF.withAlpha(80) : Gray.x00.withAlpha(80));
            g.drawOval(x + 1, y + 1, 14, 14);
            config.restore();
        }

        @Override
        public int getIconWidth() {
            return JBUI.scale((int)16);
        }

        @Override
        public int getIconHeight() {
            return JBUI.scale((int)16);
        }
    }
}

