/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.editor.actions;

import com.intellij.DynamicBundle;
import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.SimpleEditorPreview;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileEditor.impl.EditorEmptyTextPainter;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.openapi.options.colors.ColorSettingsPages;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.actions.IconWithTextAction;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.IdeBackgroundUtil;
import com.intellij.ui.ClickListener;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.SideBorder;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.MathUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.intellij.images.fileTypes.ImageFileTypeManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BackgroundImageDialog
extends DialogWrapper {
    private static final String EDITOR = "editor";
    private static final String FRAME = "ide";
    private final String myPropertyTmp;
    private final Project myProject;
    private final ButtonGroup myAnchorGroup;
    private final ButtonGroup myFillGroup;
    private String myPreviewTarget;
    private ActionToolbar myToolbar;
    private JPanel myRoot;
    private JSlider myOpacitySlider;
    private JSpinner myOpacitySpinner;
    private JPanel myPreviewPanel;
    private ComboboxWithBrowseButton myPathField;
    private JBCheckBox myThisProjectOnlyCb;
    private JPanel myFlipPanel;
    private JPanel myAnchorPanel;
    private JPanel myFillPanel;
    private JPanel myTargetPanel;
    private final JBCheckBox myFlipHorCb;
    private final JBCheckBox myFlipVerCb;
    boolean myAdjusting;
    private final Map<String, String> myResults;
    private final SimpleEditorPreview myEditorPreview;
    private final JComponent myIdePreview;

    public BackgroundImageDialog(@NotNull Project project, @Nullable String selectedPath) {
        super(project, true);
        this.$$$setupUI$$$();
        this.myAnchorGroup = new ButtonGroup();
        this.myFillGroup = new ButtonGroup();
        this.myFlipHorCb = new JBCheckBox();
        this.myFlipVerCb = new JBCheckBox();
        this.myResults = new HashMap<String, String>();
        this.myProject = project;
        this.setTitle(IdeBundle.message((String)"dialog.title.background.image", (Object[])new Object[0]));
        this.myEditorPreview = BackgroundImageDialog.createEditorPreview();
        this.myIdePreview = BackgroundImageDialog.createFramePreview();
        this.myPropertyTmp = this.getSystemProp() + "#" + project.getLocationHash();
        UiNotifyConnector.doWhenFirstShown((JComponent)this.myRoot, () -> IdeBackgroundUtil.createTemporaryBackgroundTransform((JPanel)this.myPreviewPanel, (String)this.myPropertyTmp, (Disposable)this.getDisposable()));
        this.setupComponents();
        this.restoreRecentImages();
        if (StringUtil.isNotEmpty((String)selectedPath)) {
            this.myResults.put(BackgroundImageDialog.getSystemProp(true), selectedPath);
            this.myResults.put(BackgroundImageDialog.getSystemProp(false), selectedPath);
            this.setSelectedPath(selectedPath);
        }
        this.targetChanged(EDITOR);
        this.init();
        this.myEditorPreview.getPanel().setPreferredSize(new Dimension(0, 0));
        this.pack();
    }

    protected Action @NotNull [] createActions() {
        return (Action[])ArrayUtil.append((Object[])super.createActions(), (Object)new AbstractAction(IdeBundle.message((String)"button.clear.and.close", (Object[])new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                BackgroundImageDialog.this.doClearAction();
            }
        });
    }

    private void createUIComponents() {
        ComboBox comboBox = new ComboBox((ComboBoxModel)new CollectionComboBoxModel(), 100);
        this.myPathField = new ComboboxWithBrowseButton((JComboBox)comboBox);
    }

    protected void dispose() {
        super.dispose();
        this.myEditorPreview.disposeUIResources();
        System.getProperties().remove(this.myPropertyTmp);
    }

    @NotNull
    private static SimpleEditorPreview createEditorPreview() {
        int index;
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        ColorAndFontOptions options = new ColorAndFontOptions();
        options.reset();
        options.selectScheme(scheme.getName());
        ColorSettingsPage[] pages = ColorSettingsPages.getInstance().getRegisteredPages();
        int attempt = 0;
        while (StringUtil.countNewLines((CharSequence)pages[index = (int)Math.round(Math.random() * (double)(pages.length - 1))].getDemoText()) < 8 && ++attempt < 10) {
        }
        return new SimpleEditorPreview(options, pages[index], false);
    }

    @NotNull
    private static JComponent createFramePreview() {
        final EditorEmptyTextPainter painter = (EditorEmptyTextPainter)ServiceManager.getService(EditorEmptyTextPainter.class);
        JBPanelWithEmptyText panel = new JBPanelWithEmptyText(){

            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                painter.paintEmptyText((JComponent)((Object)this), g);
            }

            public Color getBackground() {
                return IdeBackgroundUtil.getIdeBackgroundColor();
            }

            public boolean isOpaque() {
                return true;
            }
        };
        panel.getEmptyText().clear();
        return panel;
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    @NotNull
    private String getRecentItemsKey() {
        return this.getDimensionServiceKey() + "#recent";
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myRoot;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myPathField;
    }

    private void setupComponents() {
        AbstractButton button;
        this.myAdjusting = true;
        this.myPreviewPanel.setLayout(new CardLayout());
        this.myPreviewPanel.add((Component)this.myEditorPreview.getPanel(), EDITOR);
        this.myPreviewPanel.add((Component)this.myIdePreview, FRAME);
        UIUtil.removeScrollBorder((Component)this.myPreviewPanel);
        this.myPreviewPanel.setBorder((Border)new SideBorder(JBColor.border(), 15));
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add(this.createToggleAction(EDITOR, IdeBundle.message((String)"toggle.editor.and.tools", (Object[])new Object[0])));
        actionGroup.add(this.createToggleAction(FRAME, IdeBundle.message((String)"toggle.empty.frame", (Object[])new Object[0])));
        this.myToolbar = ActionManager.getInstance().createActionToolbar(this.getTitle(), (ActionGroup)actionGroup, true);
        JComponent toolbarComponent = this.myToolbar.getComponent();
        toolbarComponent.setBorder((Border)JBUI.Borders.empty());
        this.myTargetPanel.add(toolbarComponent);
        BackgroundImageDialog.initFlipPanel(this.myFlipPanel, this.myFlipHorCb, this.myFlipVerCb);
        BackgroundImageDialog.initAnchorPanel(this.myAnchorPanel, this.myAnchorGroup);
        BackgroundImageDialog.initFillPanel(this.myFillPanel, this.myFillGroup, this.getDisposable());
        ((CardLayout)this.myPreviewPanel.getLayout()).show(this.myPreviewPanel, EDITOR);
        this.myPathField.getComboBox().setEditable(true);
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, false, true, false).withFileFilter(file -> ImageFileTypeManager.getInstance().isImage((VirtualFile)file));
        this.myPathField.addBrowseFolderListener(null, null, null, descriptor, TextComponentAccessor.STRING_COMBOBOX_WHOLE_TEXT);
        JTextComponent textComponent = this.getComboEditor();
        textComponent.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (BackgroundImageDialog.this.myAdjusting) {
                    return;
                }
                BackgroundImageDialog.this.imagePathChanged();
            }
        });
        Enumeration<AbstractButton> e = this.getFillRbGroup().getElements();
        while (e.hasMoreElements()) {
            button = e.nextElement();
            button.setActionCommand(button.getText());
            button.addItemListener(this::fillOrAnchorChanged);
        }
        e = this.getAnchorRbGroup().getElements();
        while (e.hasMoreElements()) {
            button = e.nextElement();
            button.setActionCommand(button.getText());
            button.addItemListener(this::fillOrAnchorChanged);
        }
        this.myFlipHorCb.addItemListener(this::fillOrAnchorChanged);
        this.myFlipVerCb.addItemListener(this::fillOrAnchorChanged);
        ChangeListener opacitySync = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                boolean b;
                if (BackgroundImageDialog.this.myAdjusting) {
                    return;
                }
                BackgroundImageDialog.this.myAdjusting = true;
                boolean bl = b = e.getSource() == BackgroundImageDialog.this.myOpacitySpinner;
                if (b) {
                    int value = (Integer)BackgroundImageDialog.this.myOpacitySpinner.getValue();
                    BackgroundImageDialog.this.myOpacitySpinner.setValue(MathUtil.clamp((int)value, (int)0, (int)100));
                    BackgroundImageDialog.this.myOpacitySlider.setValue(value);
                } else {
                    BackgroundImageDialog.this.myOpacitySpinner.setValue(BackgroundImageDialog.this.myOpacitySlider.getValue());
                }
                BackgroundImageDialog.this.myAdjusting = false;
                BackgroundImageDialog.this.opacityChanged();
            }
        };
        this.myOpacitySpinner.addChangeListener(opacitySync);
        this.myOpacitySlider.addChangeListener(opacitySync);
        this.myOpacitySlider.setValue(15);
        this.myOpacitySpinner.setValue(15);
        boolean perProject = !Objects.equals(IdeBackgroundUtil.getBackgroundSpec((Project)this.myProject, (String)BackgroundImageDialog.getSystemProp(true)), IdeBackgroundUtil.getBackgroundSpec(null, (String)BackgroundImageDialog.getSystemProp(true)));
        this.myThisProjectOnlyCb.setSelected(perProject);
        this.myAdjusting = false;
    }

    private AnAction createToggleAction(final String target, final String text) {
        class A
        extends IconWithTextAction
        implements DumbAware,
        Toggleable {
            A() {
            }

            public void update(@NotNull AnActionEvent e) {
                e.getPresentation().setText(text);
                Toggleable.setSelected((Presentation)e.getPresentation(), (boolean)target.equals(BackgroundImageDialog.this.myPreviewTarget));
                super.update(e);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                BackgroundImageDialog.this.targetChanged(target);
                BackgroundImageDialog.this.myToolbar.updateActionsImmediately();
            }
        }
        return new A();
    }

    private void opacityChanged() {
        this.updatePreview();
    }

    private void imagePathChanged() {
        this.updatePreview();
    }

    private void fillOrAnchorChanged(ItemEvent event) {
        this.updatePreview();
    }

    private void targetChanged(String target) {
        this.myPreviewTarget = target;
        this.retrieveExistingValue();
        ((CardLayout)this.myPreviewPanel.getLayout()).show(this.myPreviewPanel, this.myPreviewTarget);
        if (EDITOR.equals(this.myPreviewTarget)) {
            this.myEditorPreview.updateView();
        }
        this.updatePreview();
    }

    public void setSelectedPath(String path) {
        if (StringUtil.isEmptyOrSpaces((String)path)) {
            this.getComboEditor().setText("");
        } else {
            CollectionComboBoxModel<String> comboModel = this.getComboModel();
            if (!comboModel.contains((Object)path)) {
                comboModel.add((Object)path);
            }
            comboModel.setSelectedItem((Object)path);
            this.getComboEditor().setCaretPosition(0);
        }
    }

    private void retrieveExistingValue() {
        this.myAdjusting = true;
        String prop = this.getSystemProp();
        JBIterable possibleValues = JBIterable.of((Object)this.myResults.get(prop)).append((Object)StringUtil.nullize((String)IdeBackgroundUtil.getBackgroundSpec((Project)this.myProject, (String)prop))).append(this.myResults.values());
        String value = StringUtil.notNullize((String)((String)ObjectUtils.coalesce((Iterable)possibleValues)));
        String[] split = value.split(",");
        int opacity = split.length > 1 ? StringUtil.parseInt((String)split[1], (int)15) : 15;
        String fill = split.length > 2 ? split[2] : "scale";
        String anchor = split.length > 3 ? split[3] : "center";
        String flip = split.length > 4 ? split[4] : "none";
        this.setSelectedPath(split[0]);
        this.myOpacitySlider.setValue(opacity);
        this.myOpacitySpinner.setValue(opacity);
        BackgroundImageDialog.setSelected(this.getFillRbGroup(), fill);
        BackgroundImageDialog.setSelected(this.getAnchorRbGroup(), anchor);
        this.myFlipHorCb.setSelected("flipHV".equals(flip) || "flipH".equals(flip));
        this.myFlipVerCb.setSelected("flipHV".equals(flip) || "flipV".equals(flip));
        this.myAdjusting = false;
    }

    public void doCancelAction() {
        super.doCancelAction();
        this.storeRecentImages();
    }

    private void doClearAction() {
        this.close(0);
        this.storeRecentImages();
        String prop = this.getSystemProp();
        PropertiesComponent.getInstance((Project)this.myProject).setValue(prop, null);
        PropertiesComponent.getInstance().setValue(prop, null);
        IdeBackgroundUtil.repaintAllWindows();
    }

    protected void doOKAction() {
        super.doOKAction();
        this.storeRecentImages();
        String value = this.calcNewValue();
        String prop = this.getSystemProp();
        this.myResults.put(prop, value);
        if (value.startsWith(",")) {
            value = null;
        }
        boolean perProject = this.myThisProjectOnlyCb.isSelected();
        PropertiesComponent.getInstance((Project)this.myProject).setValue(prop, perProject ? value : null);
        if (!perProject) {
            PropertiesComponent.getInstance().setValue(prop, value);
        }
        IdeBackgroundUtil.repaintAllWindows();
    }

    private void storeRecentImages() {
        List items = this.getComboModel().getItems();
        PropertiesComponent.getInstance().setValue(this.getRecentItemsKey(), StringUtil.join((Collection)ContainerUtil.getFirstItems((List)items, (int)5), (String)"\n"));
    }

    private CollectionComboBoxModel<String> getComboModel() {
        return (CollectionComboBoxModel)this.myPathField.getComboBox().getModel();
    }

    private JTextComponent getComboEditor() {
        return (JTextComponent)this.myPathField.getComboBox().getEditor().getEditorComponent();
    }

    private void restoreRecentImages() {
        String value = PropertiesComponent.getInstance().getValue(this.getRecentItemsKey());
        if (value == null) {
            return;
        }
        CollectionComboBoxModel<String> model = this.getComboModel();
        for (String s : value.split("\n")) {
            if (StringUtil.isEmptyOrSpaces((String)s) || model.contains((Object)s)) continue;
            model.add((Object)s);
        }
    }

    private String getSystemProp() {
        return BackgroundImageDialog.getSystemProp(EDITOR.equals(this.myPreviewTarget));
    }

    @NotNull
    private static String getSystemProp(boolean forEditor) {
        return forEditor ? "idea.background.editor" : "idea.background.frame";
    }

    private void updatePreview() {
        if (this.myAdjusting) {
            return;
        }
        String prop = this.getSystemProp();
        String value = this.calcNewValue();
        System.setProperty(this.myPropertyTmp, value);
        this.myResults.put(prop, value);
        this.myPreviewPanel.validate();
        this.myPreviewPanel.repaint();
        boolean clear = value.startsWith(",");
        this.getOKAction().setEnabled(!clear);
    }

    @NotNull
    private String calcNewValue() {
        String path = (String)this.myPathField.getComboBox().getEditor().getItem();
        String type = this.getFillRbGroup().getSelection().getActionCommand().replace('-', '_');
        String anchor = this.getAnchorRbGroup().getSelection().getActionCommand().replace('-', '_');
        int flip = (this.myFlipHorCb.isSelected() ? 1 : 0) << 1 | (this.myFlipVerCb.isSelected() ? 1 : 0);
        return path.trim() + "," + this.myOpacitySpinner.getValue() + "," + StringUtil.toLowerCase((String)(type + "," + anchor)) + (flip == 0 ? "" : "," + (flip == 3 ? "flipHV" : (flip == 2 ? "flipH" : "flipV")));
    }

    private static void setSelected(ButtonGroup group, String fill) {
        Enumeration<AbstractButton> e = group.getElements();
        while (e.hasMoreElements()) {
            AbstractButton button = e.nextElement();
            String s = button.getActionCommand().replace('-', '_');
            if (!s.equalsIgnoreCase(fill)) continue;
            button.setSelected(true);
            break;
        }
    }

    private ButtonGroup getFillRbGroup() {
        return this.myFillGroup;
    }

    private ButtonGroup getAnchorRbGroup() {
        return this.myAnchorGroup;
    }

    @NotNull
    private static Color getSelectionBackground() {
        return ColorUtil.mix((Color)UIUtil.getListSelectionBackground((boolean)true), (Color)UIUtil.getLabelBackground(), (double)(StartupUiUtil.isUnderDarcula() ? 0.5 : 0.75));
    }

    private static void initFlipPanel(@NotNull JPanel p, @NotNull JBCheckBox flipHorCb, @NotNull JBCheckBox flipVerCb) {
        flipHorCb.setToolTipText(IdeBundle.message((String)"tooltip.flip.vertically", (Object[])new Object[0]));
        flipVerCb.setToolTipText(IdeBundle.message((String)"tooltip.flip.horizontally", (Object[])new Object[0]));
        p.setLayout(new GridLayout(1, 2, 1, 1));
        Color color = BackgroundImageDialog.getSelectionBackground();
        JBPanelWithEmptyText h = BackgroundImageDialog.addClickablePanel(p, (JToggleButton)flipHorCb, color);
        JBPanelWithEmptyText v = BackgroundImageDialog.addClickablePanel(p, (JToggleButton)flipVerCb, color);
        h.setLayout((LayoutManager)new BorderLayout());
        h.add((Component)new JBLabel(AllIcons.Actions.SplitVertically), (Object)"Center");
        v.setLayout((LayoutManager)new BorderLayout());
        v.add((Component)new JBLabel(AllIcons.Actions.SplitHorizontally), (Object)"Center");
    }

    private static void initAnchorPanel(@NotNull JPanel p, @NotNull ButtonGroup buttonGroup) {
        IdeBackgroundUtil.Anchor[] values = IdeBackgroundUtil.Anchor.values();
        String[] names = new String[values.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = StringUtil.toLowerCase((String)values[i].name().replace('_', '-'));
        }
        Color color = BackgroundImageDialog.getSelectionBackground();
        p.setLayout(new GridLayout(3, 3, 1, 1));
        for (int i = 0; i < names.length; ++i) {
            JRadioButton button = new JRadioButton(names[i], values[i] == IdeBackgroundUtil.Anchor.CENTER);
            button.setToolTipText(StringUtil.capitalize((String)button.getText().replace('-', ' ')));
            buttonGroup.add(button);
            BackgroundImageDialog.addClickablePanel(p, button, color);
        }
    }

    private static void initFillPanel(@NotNull JPanel p, @NotNull ButtonGroup buttonGroup, @NotNull Disposable disposable) {
        IdeBackgroundUtil.Fill[] values = IdeBackgroundUtil.Fill.values();
        String[] names = new String[values.length];
        BufferedImage image = BackgroundImageDialog.sampleImage();
        for (int i = 0; i < names.length; ++i) {
            names[i] = StringUtil.toLowerCase((String)values[i].name().replace('_', '-'));
        }
        Color color = BackgroundImageDialog.getSelectionBackground();
        p.setLayout(new GridLayout(1, values.length, 1, 1));
        for (int i = 0; i < values.length; ++i) {
            JRadioButton button = new JRadioButton(names[i], values[i] == IdeBackgroundUtil.Fill.SCALE);
            buttonGroup.add(button);
            button.setToolTipText(StringUtil.capitalize((String)button.getText().replace('-', ' ')));
            JBPanelWithEmptyText clickablePanel = BackgroundImageDialog.addClickablePanel(p, button, color);
            IdeBackgroundUtil.createTemporaryBackgroundTransform((JPanel)clickablePanel, (Image)image, (IdeBackgroundUtil.Fill)values[i], (IdeBackgroundUtil.Anchor)IdeBackgroundUtil.Anchor.CENTER, (float)1.0f, (Insets)JBUI.insets((int)2), (Disposable)disposable);
        }
    }

    @NotNull
    private static BufferedImage sampleImage() {
        int size = 16;
        BufferedImage image = new BufferedImage(size, size, 2);
        Graphics ig = image.getGraphics();
        ig.setColor(new Color(0, true));
        ig.fillRect(0, 0, size, size);
        Color imageColor = UIUtil.getLabelForeground();
        ig.setColor(imageColor);
        ig.drawRect(size / 4, size / 4, size / 2 - 1, size / 2 - 1);
        ig.drawRect(1, 1, size - 3, size - 3);
        ig.dispose();
        return image;
    }

    @NotNull
    private static JBPanelWithEmptyText addClickablePanel(final @NotNull JPanel buttonPanel, final @NotNull JToggleButton button, final @NotNull Color color) {
        JBPanelWithEmptyText panel = new JBPanelWithEmptyText(){

            public Dimension getPreferredSize() {
                Dimension d = super.getSize();
                d.width = d.height = Math.max(d.width, d.height);
                return d;
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }

            public Color getBackground() {
                return button.isSelected() ? color : super.getBackground();
            }

            public boolean isOpaque() {
                return true;
            }
        };
        panel.getEmptyText().clear();
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                button.setSelected(button instanceof JRadioButton || !button.isSelected());
                buttonPanel.invalidate();
                buttonPanel.repaint();
                return true;
            }
        }.installOn((Component)panel);
        panel.setBorder(BorderFactory.createLineBorder(color));
        buttonPanel.add((Component)panel);
        return panel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JBCheckBox jBCheckBox;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        JSpinner jSpinner;
        JSlider jSlider;
        JPanel jPanel5;
        JPanel jPanel6;
        this.createUIComponents();
        this.myRoot = jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
        this.myPreviewPanel = jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(0, 0));
        jPanel6.add((Component)jPanel5, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(5, 7, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        ComboboxWithBrowseButton comboboxWithBrowseButton = this.myPathField;
        jPanel7.add((Component)comboboxWithBrowseButton, new GridConstraints(0, 2, 1, 5, 0, 1, 3, 0, null, null, null));
        this.myOpacitySlider = jSlider = new JSlider();
        jSlider.setPaintTicks(false);
        jPanel7.add((Component)jSlider, new GridConstraints(1, 2, 1, 4, 8, 1, 6, 0, null, null, null));
        this.myOpacitySpinner = jSpinner = new JSpinner();
        jPanel7.add((Component)jSpinner, new GridConstraints(1, 6, 1, 1, 8, 1, 0, 0, new Dimension(64, 16), null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/IdeBundle", BackgroundImageDialog.class).getString("label.text.image"));
        jPanel7.add((Component)jBLabel, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/IdeBundle", BackgroundImageDialog.class).getString("label.text.opacity"));
        jPanel7.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myFillPanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel7.add((Component)jPanel4, new GridConstraints(2, 5, 3, 1, 0, 3, 0, 0, null, null, null));
        this.myAnchorPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel7.add((Component)jPanel3, new GridConstraints(2, 6, 3, 1, 0, 3, 0, 0, null, null, null));
        this.myFlipPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel7.add((Component)jPanel2, new GridConstraints(2, 4, 1, 1, 0, 3, 0, 0, null, null, null));
        this.myThisProjectOnlyCb = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/IdeBundle", BackgroundImageDialog.class).getString("checkbox.text.this.project.only"));
        jPanel7.add((Component)jBCheckBox, new GridConstraints(3, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        this.myTargetPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel7.add((Component)jPanel, new GridConstraints(4, 0, 1, 5, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel7.add((Component)spacer, new GridConstraints(3, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel7.add((Component)spacer2, new GridConstraints(2, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        jBLabel.setLabelFor((Component)comboboxWithBrowseButton);
        jBLabel2.setLabelFor(jSpinner);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

