/*
 * Decompiled with CFR 0.152.
 */
package trebuchet.io;

import java.util.concurrent.ArrayBlockingQueue;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.Nullable;
import trebuchet.io.Consumer;
import trebuchet.io.Producer;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\u0014B\u000f\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\u000f\u0010\u0012\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ltrebuchet/io/Pipe;", "T", "Ltrebuchet/io/Producer;", "Ltrebuchet/io/Consumer;", "capacity", "", "(I)V", "consumerClosed", "", "producerClosed", "queue", "Ljava/util/concurrent/ArrayBlockingQueue;", "Ltrebuchet/io/Pipe$Packet;", "add", "", "data", "(Ljava/lang/Object;)V", "close", "next", "()Ljava/lang/Object;", "Packet", "intellij.android.profilers.atrace"})
public final class Pipe<T>
implements Producer<T>,
Consumer<T> {
    private final ArrayBlockingQueue<Packet<T>> queue;
    private boolean producerClosed;
    private boolean consumerClosed;

    @Override
    public void add(T data) {
        if (data == null) {
            throw (Throwable)new IllegalStateException("Unable to send null");
        }
        if (this.producerClosed) {
            throw (Throwable)new IllegalStateException("Already closed");
        }
        this.queue.put(new Packet<T>(data));
    }

    @Override
    public void close() {
        if (!this.producerClosed) {
            this.producerClosed = true;
            this.queue.put(new Packet<Object>(null));
        }
    }

    @Override
    @Nullable
    public T next() {
        if (this.consumerClosed) {
            return null;
        }
        Packet<T> packet = this.queue.take();
        if (packet.getData() == null) {
            this.consumerClosed = true;
        }
        return packet.getData();
    }

    public Pipe(int capacity) {
        this.queue = new ArrayBlockingQueue(capacity);
    }

    public /* synthetic */ Pipe(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 4;
        }
        this(n);
    }

    public Pipe() {
        this(0, 1, null);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0002\u0018\u0000*\u0006\b\u0001\u0010\u0001 \u00012\u00020\u0002B\u000f\u0012\b\u0010\u0003\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\u0002\u0010\u0004R\u0015\u0010\u0003\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\b"}, d2={"Ltrebuchet/io/Pipe$Packet;", "T", "", "data", "(Ljava/lang/Object;)V", "getData", "()Ljava/lang/Object;", "Ljava/lang/Object;", "intellij.android.profilers.atrace"})
    private static final class Packet<T> {
        @Nullable
        private final T data;

        @Nullable
        public final T getData() {
            return this.data;
        }

        public Packet(@Nullable T data) {
            this.data = data;
        }
    }
}

