/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.stacktrace;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.profilers.stacktrace.CodeLocation;
import com.android.tools.profilers.stacktrace.CodeNavigator;
import com.android.tools.profilers.stacktrace.StackFrameParser;
import com.android.tools.profilers.stacktrace.ThreadId;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class StackTraceModel
extends AspectModel<Aspect> {
    private static final int INVALID_INDEX = -1;
    @NotNull
    private final CodeNavigator myCodeNavigator;
    @NotNull
    private ThreadId myThreadId;
    @NotNull
    private List<CodeLocation> myStackFrames;
    private int mySelectedIndex = -1;

    public StackTraceModel(@NotNull CodeNavigator codeNavigator) {
        this.myCodeNavigator = codeNavigator;
        this.myStackFrames = Collections.emptyList();
        this.myThreadId = ThreadId.INVALID_THREAD_ID;
    }

    public void setStackFrames(@NotNull ThreadId threadId, @NotNull List<CodeLocation> stackFrames) {
        this.updateStackFrames(threadId, (List<CodeLocation>)ImmutableList.copyOf(stackFrames));
    }

    public void setStackFrames(@NotNull String trace) {
        this.updateStackFrames(ThreadId.INVALID_THREAD_ID, Arrays.stream(trace.split("\\n")).map(stackFrame -> new StackFrameParser((String)stackFrame).toCodeLocation()).collect(Collectors.toList()));
    }

    public void clearStackFrames() {
        this.updateStackFrames(ThreadId.INVALID_THREAD_ID, Collections.emptyList());
    }

    @NotNull
    public CodeNavigator getCodeNavigator() {
        return this.myCodeNavigator;
    }

    private void updateStackFrames(@NotNull ThreadId threadId, @NotNull List<CodeLocation> stackFrames) {
        this.clearSelection();
        this.myStackFrames = stackFrames;
        this.myThreadId = threadId;
        this.changed(Aspect.STACK_FRAMES);
    }

    @NotNull
    public ThreadId getThreadId() {
        return this.myThreadId;
    }

    @NotNull
    public List<CodeLocation> getCodeLocations() {
        return this.myStackFrames;
    }

    public int getSelectedIndex() {
        return this.mySelectedIndex;
    }

    public Type getSelectedType() {
        if (this.mySelectedIndex >= 0 && this.mySelectedIndex < this.myStackFrames.size()) {
            return Type.STACK_FRAME;
        }
        if (this.mySelectedIndex == this.myStackFrames.size()) {
            return Type.THREAD_ID;
        }
        return Type.INVALID;
    }

    public void setSelectedIndex(int index) {
        int size = this.myStackFrames.size() + (ThreadId.INVALID_THREAD_ID.equals(this.myThreadId) ? 0 : 1);
        int newIndex = index >= 0 && index < size ? index : -1;
        boolean indexChanging = newIndex != this.mySelectedIndex;
        this.mySelectedIndex = newIndex;
        if (indexChanging) {
            this.changed(Aspect.SELECTED_LOCATION);
            if (this.getSelectedType() == Type.STACK_FRAME) {
                this.myCodeNavigator.navigate(this.myStackFrames.get(this.mySelectedIndex));
            }
        }
    }

    public void clearSelection() {
        this.setSelectedIndex(-1);
    }

    public static enum Type {
        INVALID,
        STACK_FRAME,
        THREAD_ID;

    }

    public static enum Aspect {
        STACK_FRAMES,
        SELECTED_LOCATION;

    }
}

