/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.stacktrace;

import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.stacktrace.CodeLocation;
import com.google.common.collect.Lists;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class CodeNavigator {
    private final List<Listener> myListeners = Lists.newArrayList();
    @NotNull
    private final FeatureTracker myFeatureTracker;

    public CodeNavigator(@NotNull FeatureTracker featureTracker) {
        this.myFeatureTracker = featureTracker;
    }

    public final void addListener(@NotNull Listener listener) {
        this.myListeners.add(listener);
    }

    public final void removeListener(@NotNull Listener listener) {
        this.myListeners.remove(listener);
    }

    public final void navigate(@NotNull CodeLocation location) {
        this.handleNavigate(location);
        this.myListeners.forEach(l -> l.onNavigated(location));
        this.myFeatureTracker.trackNavigateToCode();
    }

    public abstract boolean isNavigatable(@NotNull CodeLocation var1);

    protected abstract void handleNavigate(@NotNull CodeLocation var1);

    public static interface Listener {
        public void onNavigated(@NotNull CodeLocation var1);
    }
}

