/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network.details;

import com.android.tools.adtui.TreeWalker;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.event.NestedScrollPaneMouseWheelListener;
import com.android.tools.profilers.ContentType;
import com.android.tools.profilers.IdeProfilerComponents;
import com.android.tools.profilers.ProfilerFonts;
import com.android.tools.profilers.dataviewer.DataViewer;
import com.android.tools.profilers.network.NetworkConnectionsModel;
import com.android.tools.profilers.network.details.TabUiUtils;
import com.android.tools.profilers.network.httpdata.HttpData;
import com.android.tools.profilers.network.httpdata.Payload;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.JBEmptyBorder;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class HttpDataComponentFactory {
    private static final String ID_PAYLOAD_VIEWER = "PAYLOAD_VIEWER";
    private static final Border PAYLOAD_BORDER = new JBEmptyBorder(6, 0, 0, 0);
    private final NetworkConnectionsModel myModel;
    private final HttpData myHttpData;

    public HttpDataComponentFactory(@NotNull NetworkConnectionsModel model, @NotNull HttpData httpData) {
        this.myModel = model;
        this.myHttpData = httpData;
    }

    @VisibleForTesting
    @Nullable
    static JComponent findPayloadViewer(@Nullable JComponent body) {
        if (body == null) {
            return null;
        }
        return TabUiUtils.findComponentWithUniqueName(body, ID_PAYLOAD_VIEWER);
    }

    @NotNull
    public JComponent createHeaderComponent(@NotNull ConnectionType type) {
        return TabUiUtils.createStyledMapComponent(type.getHeader(this.myHttpData).getFields());
    }

    @NotNull
    private String getBodyTitle(@NotNull ConnectionType type) {
        HttpData.Header header = type.getHeader(this.myHttpData);
        HttpData.ContentType contentType = header.getContentType();
        if (contentType.isEmpty()) {
            return "Body";
        }
        return String.format("Body ( %s )", HttpDataComponentFactory.getDisplayName(contentType));
    }

    @NotNull
    public JComponent createBodyComponent(@NotNull IdeProfilerComponents components, @NotNull ConnectionType type) {
        Payload payload = type.getPayload(this.myModel, this.myHttpData);
        if (payload.getBytes().isEmpty()) {
            return TabUiUtils.createHideablePanel(this.getBodyTitle(type), new JLabel("Not available"), null);
        }
        JComponent rawDataComponent = HttpDataComponentFactory.createRawDataComponent(payload, components);
        JComponent parsedDataComponent = HttpDataComponentFactory.createParsedDataComponent(payload, components);
        JComponent bodyComponent = rawDataComponent;
        JLabel northEastComponent = null;
        if (parsedDataComponent != null) {
            JLabel toggleLabel;
            final CardLayout cardLayout = new CardLayout();
            final JPanel payloadPanel = new JPanel(cardLayout);
            final String cardViewParsed = "View Parsed";
            final String cardViewSource = "View Source";
            parsedDataComponent.setName(cardViewParsed);
            rawDataComponent.setName(cardViewSource);
            payloadPanel.add((Component)parsedDataComponent, cardViewParsed);
            payloadPanel.add((Component)rawDataComponent, cardViewSource);
            bodyComponent = payloadPanel;
            northEastComponent = toggleLabel = new JLabel(cardViewSource);
            final Color toggleHoverColor = AdtUiUtils.overlayColor((int)toggleLabel.getBackground().getRGB(), (int)toggleLabel.getForeground().getRGB(), (float)0.9f);
            final Color toggleDefaultColor = AdtUiUtils.overlayColor((int)toggleLabel.getBackground().getRGB(), (int)toggleHoverColor.getRGB(), (float)0.6f);
            toggleLabel.setForeground(toggleDefaultColor);
            toggleLabel.setFont(ProfilerFonts.STANDARD_FONT);
            toggleLabel.setBorder((Border)new JBEmptyBorder(0, 10, 0, 5));
            toggleLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    toggleLabel.setText(cardViewSource.equals(toggleLabel.getText()) ? cardViewParsed : cardViewSource);
                    cardLayout.next(payloadPanel);
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    toggleLabel.setForeground(toggleHoverColor);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    toggleLabel.setForeground(toggleDefaultColor);
                }
            });
        }
        bodyComponent.setName(type.getBodyComponentId());
        return TabUiUtils.createHideablePanel(this.getBodyTitle(type), bodyComponent, northEastComponent);
    }

    @NotNull
    private static JComponent createRawDataComponent(@NotNull Payload payload, @NotNull IdeProfilerComponents components) {
        ContentType contentType = ContentType.fromMimeType(payload.getContentType().getMimeType());
        DataViewer viewer = components.createDataViewer(payload.getBytes().toByteArray(), contentType, DataViewer.Style.RAW);
        JComponent viewerComponent = viewer.getComponent();
        viewerComponent.setName(ID_PAYLOAD_VIEWER);
        viewerComponent.setBorder(PAYLOAD_BORDER);
        JPanel compressedVerticalPanel = new JPanel(new CompressedVerticalLayout());
        compressedVerticalPanel.add(viewerComponent);
        return compressedVerticalPanel;
    }

    @Nullable
    private static JComponent createParsedDataComponent(@NotNull Payload payload, @NotNull IdeProfilerComponents components) {
        if (payload.getContentType().isFormData()) {
            String contentToParse = payload.getBytes().toStringUtf8();
            LinkedHashMap<String, String> parsedContent = new LinkedHashMap<String, String>();
            Stream<String[]> parsedContentStream = Arrays.stream(contentToParse.trim().split("&")).map(s -> s.split("=", 2));
            parsedContentStream.forEach(a -> parsedContent.put(a[0], ((String[])a).length > 1 ? a[1] : ""));
            return TabUiUtils.createStyledMapComponent(parsedContent);
        }
        ContentType contentType = ContentType.fromMimeType(payload.getContentType().getMimeType());
        DataViewer viewer = components.createDataViewer(payload.getBytes().toByteArray(), contentType, DataViewer.Style.PRETTY);
        if (viewer.getStyle() == DataViewer.Style.PRETTY) {
            JComponent viewerComponent = viewer.getComponent();
            viewerComponent.setBorder(PAYLOAD_BORDER);
            new TreeWalker((Component)viewerComponent).descendantStream().filter(c -> c instanceof JScrollPane).map(c -> (JScrollPane)c).forEach(scroller -> NestedScrollPaneMouseWheelListener.installOn((JScrollPane)scroller));
            return viewerComponent;
        }
        return null;
    }

    @VisibleForTesting
    static String getDisplayName(@NotNull HttpData.ContentType contentType) {
        String name;
        String mimeType = contentType.getMimeType().trim();
        if (mimeType.isEmpty()) {
            return mimeType;
        }
        if (contentType.isFormData()) {
            return "Form Data";
        }
        String[] typeAndSubType = mimeType.split("/", 2);
        boolean showSubType = typeAndSubType.length > 1 && (typeAndSubType[0].equals("text") || typeAndSubType[0].equals("application"));
        String string = name = showSubType ? typeAndSubType[1] : typeAndSubType[0];
        if (name.isEmpty() || showSubType) {
            return StringUtil.toUpperCase((String)name);
        }
        return StringUtil.toUpperCase((String)name.substring(0, 1)) + name.substring(1);
    }

    @VisibleForTesting
    static class CompressedVerticalLayout
    implements LayoutManager2 {
        private static final int INVALID_SIZE = -1;
        private final Dimension myMinSize = new Dimension(-1, -1);
        private final Dimension myPreferredSize = new Dimension(-1, -1);
        private final Dimension myMaxSize = new Dimension(-1, -1);
        private boolean myNeedsLayout = true;

        CompressedVerticalLayout() {
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return CompressedVerticalLayout.getSize(parent, c -> c.getMinimumSize(), this.myMinSize);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int parentWidth = parent.getWidth();
            return CompressedVerticalLayout.getSize(parent, c -> {
                c.setBounds(0, 0, parentWidth, Short.MAX_VALUE);
                return c.getPreferredSize();
            }, this.myPreferredSize);
        }

        @Override
        public Dimension maximumLayoutSize(Container parent) {
            return CompressedVerticalLayout.getSize(parent, c -> c.getMaximumSize(), this.myMaxSize);
        }

        @Override
        public void layoutContainer(Container parent) {
            if (!this.myNeedsLayout) {
                return;
            }
            int componentCount = parent.getComponentCount();
            int totalWidth = parent.getWidth();
            int totalHeight = parent.getHeight();
            for (int i2 = 0; i2 < componentCount; ++i2) {
                int width;
                Component c = parent.getComponent(i2);
                if (c.isMaximumSizeSet()) {
                    Dimension maxDim = c.getMaximumSize();
                    width = Math.min(totalWidth, maxDim.width);
                    c.setBounds(0, 0, width, maxDim.height);
                }
                Dimension preferredDim = c.getPreferredSize();
                width = Math.min(totalWidth, preferredDim.width);
                int height = Math.min(totalHeight, preferredDim.height);
                c.setBounds(0, 0, width, height);
            }
            this.myNeedsLayout = false;
        }

        @Override
        public float getLayoutAlignmentX(Container target) {
            return 0.0f;
        }

        @Override
        public float getLayoutAlignmentY(Container target) {
            return 0.0f;
        }

        @Override
        public void invalidateLayout(Container target) {
            this.invalidateLayout();
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
            this.invalidateLayout();
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            this.invalidateLayout();
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            this.invalidateLayout();
        }

        @NotNull
        private static Dimension getSize(@NotNull Container parent, @NotNull Function<Component, Dimension> componentSizeGetter, @NotNull Dimension resultDimension) {
            if (resultDimension.width != -1 && resultDimension.height != -1) {
                return resultDimension;
            }
            int w = 0;
            int h = 0;
            for (Component c : parent.getComponents()) {
                Dimension d = componentSizeGetter.apply(c);
                w = Math.max(w, d.width);
                h += d.height;
            }
            resultDimension.setSize(w, h);
            return resultDimension;
        }

        private void invalidateLayout() {
            this.myMinSize.setSize(-1, -1);
            this.myPreferredSize.setSize(-1, -1);
            this.myMaxSize.setSize(-1, -1);
            this.myNeedsLayout = true;
        }
    }

    public static enum ConnectionType {
        REQUEST,
        RESPONSE;


        @NotNull
        HttpData.Header getHeader(@NotNull HttpData data) {
            return this == REQUEST ? data.getRequestHeader() : data.getResponseHeader();
        }

        @NotNull
        Payload getPayload(@NotNull NetworkConnectionsModel model, @NotNull HttpData data) {
            return this == REQUEST ? Payload.newRequestPayload(model, data) : Payload.newResponsePayload(model, data);
        }

        @NotNull
        String getBodyComponentId() {
            return this == REQUEST ? "REQUEST_PAYLOAD_COMPONENT" : "RESPONSE_PAYLOAD_COMPONENT";
        }
    }
}

