/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network.details;

import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.network.NetworkConnectionsModel;
import com.android.tools.profilers.network.details.TabContent;
import com.android.tools.profilers.network.httpdata.HttpData;
import com.android.tools.profilers.network.httpdata.StackTrace;
import com.android.tools.profilers.stacktrace.CodeLocation;
import com.android.tools.profilers.stacktrace.StackTraceView;
import com.android.tools.profilers.stacktrace.ThreadId;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CallStackTabContent
extends TabContent {
    @NotNull
    private final NetworkConnectionsModel myConnectionsModel;
    @NotNull
    private final StackTraceView myStackTraceView;

    public CallStackTabContent(@NotNull NetworkConnectionsModel model, @NotNull StackTraceView stackTraceView) {
        this.myConnectionsModel = model;
        this.myStackTraceView = stackTraceView;
    }

    @Override
    @NotNull
    public String getTitle() {
        return "Call Stack";
    }

    @Override
    @NotNull
    protected JComponent createComponent() {
        return this.myStackTraceView.getComponent();
    }

    @NotNull
    public StackTraceView getStackTraceView() {
        return this.myStackTraceView;
    }

    @Override
    public void populateFor(@Nullable HttpData data) {
        if (data != null) {
            StackTrace stackTrace = new StackTrace(data);
            this.myStackTraceView.getModel().setStackFrames(ThreadId.INVALID_THREAD_ID, (List<CodeLocation>)stackTrace.getCodeLocations());
        } else {
            this.myStackTraceView.getModel().clearStackFrames();
        }
    }

    @Override
    public void trackWith(@NotNull FeatureTracker featureTracker) {
        featureTracker.trackSelectNetworkDetailsStack();
    }
}

