/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network;

import com.android.tools.adtui.AxisComponent;
import com.android.tools.adtui.LegendComponent;
import com.android.tools.adtui.LegendConfig;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.chart.linechart.LineChart;
import com.android.tools.adtui.chart.linechart.LineConfig;
import com.android.tools.adtui.model.LineChartModel;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.ProfilerMonitor;
import com.android.tools.profilers.ProfilerMonitorView;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.network.NetworkMonitor;
import com.android.tools.profilers.network.NetworkUsage;
import com.intellij.ui.components.JBPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class NetworkMonitorView
extends ProfilerMonitorView<NetworkMonitor> {
    public NetworkMonitorView(@NotNull StudioProfilersView profilersView, @NotNull NetworkMonitor monitor) {
        super(monitor);
    }

    @Override
    protected void populateUi(JPanel container) {
        container.setLayout((LayoutManager)new TabularLayout("*", "*"));
        container.setFocusable(true);
        JLabel label = new JLabel(((NetworkMonitor)((Object)this.getMonitor())).getName());
        label.setBorder(ProfilerLayout.MONITOR_LABEL_PADDING);
        label.setVerticalAlignment(1);
        label.setForeground(ProfilerColors.MONITORS_HEADER_TEXT);
        JBPanel axisPanel = new JBPanel((LayoutManager)new BorderLayout());
        axisPanel.setOpaque(false);
        AxisComponent leftAxis = new AxisComponent(((NetworkMonitor)((Object)this.getMonitor())).getTrafficAxis(), AxisComponent.AxisOrientation.RIGHT);
        leftAxis.setShowAxisLine(false);
        leftAxis.setShowMax(true);
        leftAxis.setShowUnitAtMax(true);
        leftAxis.setHideTickAtMin(true);
        leftAxis.setMarkerLengths(ProfilerLayout.MARKER_LENGTH, ProfilerLayout.MARKER_LENGTH);
        leftAxis.setMargins(0, ProfilerLayout.Y_AXIS_TOP_MARGIN);
        axisPanel.add((Component)leftAxis, "West");
        JBPanel lineChartPanel = new JBPanel((LayoutManager)new BorderLayout());
        lineChartPanel.setOpaque(false);
        lineChartPanel.setBorder(BorderFactory.createEmptyBorder(ProfilerLayout.Y_AXIS_TOP_MARGIN, 0, 0, 0));
        NetworkUsage usage = ((NetworkMonitor)((Object)this.getMonitor())).getNetworkUsage();
        LineChart lineChart = new LineChart((LineChartModel)usage);
        LineConfig receivedConfig = new LineConfig(ProfilerColors.NETWORK_RECEIVING_COLOR).setLegendIconType(LegendConfig.IconType.LINE);
        lineChart.configure(usage.getRxSeries(), receivedConfig);
        LineConfig sentConfig = new LineConfig(ProfilerColors.NETWORK_SENDING_COLOR).setLegendIconType(LegendConfig.IconType.LINE);
        lineChart.configure(usage.getTxSeries(), sentConfig);
        lineChartPanel.add((Component)lineChart, "Center");
        lineChart.setMaxLineColor(ProfilerColors.MONITOR_MAX_LINE);
        lineChart.setMaxLineMargin(40);
        lineChart.setRenderOffset(0, (int)LineConfig.DEFAULT_DASH_STROKE.getLineWidth() / 2);
        ((NetworkMonitor)((Object)this.getMonitor())).addDependency(this).onChange((Enum)ProfilerMonitor.Aspect.FOCUS, () -> lineChart.setShowMaxLine(((NetworkMonitor)((Object)((Object)this.getMonitor()))).isFocused()));
        NetworkMonitor.NetworkLegends legends = ((NetworkMonitor)((Object)this.getMonitor())).getLegends();
        LegendComponent legend = new LegendComponent.Builder((LegendComponentModel)legends).setRightPadding(ProfilerLayout.MONITOR_LEGEND_RIGHT_PADDING).build();
        legend.setForeground(ProfilerColors.MONITORS_HEADER_TEXT);
        legend.configure((Legend)legends.getRxLegend(), new LegendConfig(lineChart.getLineConfig(usage.getRxSeries())));
        legend.configure((Legend)legends.getTxLegend(), new LegendConfig(lineChart.getLineConfig(usage.getTxSeries())));
        JBPanel legendPanel = new JBPanel((LayoutManager)new BorderLayout());
        legendPanel.setOpaque(false);
        legendPanel.add((Component)label, "West");
        legendPanel.add((Component)legend, "East");
        container.add((Component)legendPanel, new TabularLayout.Constraint(0, 0));
        container.add((Component)leftAxis, new TabularLayout.Constraint(0, 0));
        container.add((Component)lineChartPanel, new TabularLayout.Constraint(0, 0));
    }
}

