/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters.classifiers;

import com.android.tools.adtui.model.filter.Filter;
import com.android.tools.profilers.memory.ClassGrouping;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.classifiers.ClassSet;
import com.android.tools.profilers.memory.adapters.classifiers.Classifier;
import com.android.tools.profilers.memory.adapters.classifiers.ClassifierSet;
import com.android.tools.profilers.memory.adapters.classifiers.PackageSet;
import com.android.tools.profilers.memory.adapters.classifiers.ThreadSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class HeapSet
extends ClassifierSet {
    @NotNull
    private final CaptureObject myCaptureObject;
    @NotNull
    protected ClassGrouping myClassGrouping = ClassGrouping.ARRANGE_BY_CLASS;
    private final int myId;
    @NotNull
    private Filter myFilter;

    public HeapSet(@NotNull CaptureObject captureObject, @NotNull String heapName, int id) {
        super(heapName);
        this.myCaptureObject = captureObject;
        this.myId = id;
        this.myFilter = Filter.EMPTY_FILTER;
        this.setClassGrouping(ClassGrouping.ARRANGE_BY_CLASS);
    }

    public ClassGrouping getClassGrouping() {
        return this.myClassGrouping;
    }

    public void setClassGrouping(@NotNull ClassGrouping classGrouping) {
        if (this.myClassGrouping == classGrouping) {
            return;
        }
        this.myClassGrouping = classGrouping;
        List snapshotStream = this.getSnapshotInstanceStream().collect(Collectors.toList());
        List deltaStream = this.getDeltaInstanceStream().collect(Collectors.toList());
        this.myDeltaInstances.clear();
        this.mySnapshotInstances.clear();
        this.myClassifier = null;
        this.myDeltaInstances.addAll(deltaStream);
        this.mySnapshotInstances.addAll(snapshotStream);
        this.myNeedsRefiltering = true;
    }

    public int getId() {
        return this.myId;
    }

    public void selectFilter(@NotNull Filter filter) {
        if (this.myFilter.isEmpty() && filter.isEmpty()) {
            return;
        }
        boolean filterChanged = !this.myFilter.equals((Object)filter);
        this.myFilter = filter;
        this.applyFilter(filterChanged);
    }

    @NotNull
    public Filter getFilter() {
        return this.myFilter;
    }

    private void applyFilter(boolean filterChanged) {
        this.applyFilter(this.myFilter, false, filterChanged);
    }

    @Override
    @NotNull
    public Classifier createSubClassifier() {
        switch (this.myClassGrouping) {
            case ARRANGE_BY_CLASS: {
                return ClassSet.createDefaultClassifier();
            }
            case ARRANGE_BY_PACKAGE: {
                return PackageSet.createDefaultClassifier(this.myCaptureObject);
            }
            case ARRANGE_BY_CALLSTACK: {
                return ThreadSet.createDefaultClassifier(this.myCaptureObject);
            }
        }
        throw new RuntimeException("Classifier type not implemented: " + (Object)((Object)this.myClassGrouping));
    }
}

