/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.energy;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Energy;
import com.android.tools.profiler.proto.EnergyProfiler;
import com.android.tools.profilers.ProfilerClient;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class EnergyUsageDataSeries
implements DataSeries<Long> {
    @NotNull
    private final ProfilerClient myClient;
    private final Common.Session mySession;
    @NotNull
    private final Function<Energy.EnergyUsageData, Integer> myUsageExtractor;

    protected static int getTotalUsage(@NotNull Energy.EnergyUsageData usage) {
        return usage.getCpuUsage() + usage.getNetworkUsage() + usage.getLocationUsage();
    }

    public EnergyUsageDataSeries(@NotNull ProfilerClient client, Common.Session session) {
        this(client, session, EnergyUsageDataSeries::getTotalUsage);
    }

    EnergyUsageDataSeries(@NotNull ProfilerClient client, Common.Session session, @NotNull Function<Energy.EnergyUsageData, Integer> usageExtractor) {
        this.myClient = client;
        this.mySession = session;
        this.myUsageExtractor = usageExtractor;
    }

    public List<SeriesData<Long>> getDataForRange(Range range) {
        EnergyProfiler.EnergyRequest.Builder builder = EnergyProfiler.EnergyRequest.newBuilder().setSession(this.mySession);
        long bufferNs = TimeUnit.SECONDS.toNanos(1L);
        builder.setStartTimestamp(TimeUnit.MICROSECONDS.toNanos((long)range.getMin()) - bufferNs);
        builder.setEndTimestamp(TimeUnit.MICROSECONDS.toNanos((long)range.getMax()) + bufferNs);
        EnergyProfiler.EnergySamplesResponse samples = this.myClient.getEnergyClient().getSamples(builder.build());
        return samples.getSamplesList().stream().map(data -> new SeriesData(TimeUnit.NANOSECONDS.toMicros(data.getTimestamp()), (Object)this.myUsageExtractor.apply(data.getEnergyUsage()))).collect(Collectors.toList());
    }
}

