/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.energy;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.energy.EnergyDuration;
import com.android.tools.profilers.energy.EnergyEventsCountDataSeries;
import com.android.tools.profilers.energy.LegacyEnergyEventsCountDataSeries;
import com.android.tools.profilers.energy.LegacyEnergyEventsDataSeries;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class DetailedEnergyEventsCount {
    @NotNull
    private final RangedContinuousSeries myLocationCountSeries;
    @NotNull
    private final RangedContinuousSeries myWakeLockCountSeries;
    @NotNull
    private final RangedContinuousSeries myAlarmAndJobCountSeries;

    public DetailedEnergyEventsCount(@NotNull StudioProfilers profilers) {
        Range countRange = new Range(0.0, 400.0);
        this.myLocationCountSeries = new RangedContinuousSeries("Location", profilers.getTimeline().getViewRange(), countRange, DetailedEnergyEventsCount.createEventsCountSeries(profilers, kind -> kind == EnergyDuration.Kind.LOCATION));
        this.myWakeLockCountSeries = new RangedContinuousSeries("Wake Locks", profilers.getTimeline().getViewRange(), countRange, DetailedEnergyEventsCount.createEventsCountSeries(profilers, kind -> kind == EnergyDuration.Kind.WAKE_LOCK));
        this.myAlarmAndJobCountSeries = new RangedContinuousSeries("Alarms & Jobs", profilers.getTimeline().getViewRange(), countRange, DetailedEnergyEventsCount.createEventsCountSeries(profilers, kind -> kind == EnergyDuration.Kind.ALARM || kind == EnergyDuration.Kind.JOB));
    }

    @NotNull
    public RangedContinuousSeries getLocationCountSeries() {
        return this.myLocationCountSeries;
    }

    @NotNull
    public RangedContinuousSeries getWakeLockCountSeries() {
        return this.myWakeLockCountSeries;
    }

    @NotNull
    public RangedContinuousSeries getAlarmAndJobCountSeries() {
        return this.myAlarmAndJobCountSeries;
    }

    @NotNull
    private static DataSeries<Long> createEventsCountSeries(StudioProfilers profilers, Predicate<EnergyDuration.Kind> kindFilter) {
        if (profilers.getIdeServices().getFeatureConfig().isUnifiedPipelineEnabled()) {
            return new EnergyEventsCountDataSeries(profilers.getClient().getTransportClient(), profilers.getSession().getStreamId(), profilers.getSession().getPid(), kindFilter);
        }
        return new LegacyEnergyEventsCountDataSeries((RangedSeries<Common.Event>)new RangedSeries(profilers.getTimeline().getDataRange(), (DataSeries)new LegacyEnergyEventsDataSeries(profilers.getClient(), profilers.getSession())), kindFilter);
    }
}

