/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.systemtrace;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.StateChartModel;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.CpuProfilerAspect;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.LazyDataSeries;
import com.android.tools.profilers.cpu.systemtrace.CpuSystemTraceData;
import com.android.tools.profilers.cpu.systemtrace.SystemTraceFrame;
import java.util.concurrent.TimeUnit;
import javax.swing.DefaultListModel;
import org.jetbrains.annotations.NotNull;

public class CpuFramesModel
extends DefaultListModel<FrameState> {
    @NotNull
    private final CpuProfilerStage myStage;
    @NotNull
    private final Range myRange;
    @NotNull
    private final AspectObserver myAspectObserver;
    public static final long SLOW_FRAME_RATE_US = TimeUnit.MILLISECONDS.toMicros(17L);

    public CpuFramesModel(@NotNull Range range, @NotNull CpuProfilerStage stage) {
        this.myRange = range;
        this.myStage = stage;
        this.myAspectObserver = new AspectObserver();
        this.myStage.getAspect().addDependency(this.myAspectObserver).onChange((Enum)CpuProfilerAspect.CAPTURE_SELECTION, this::captureStateChanged);
        range.addDependency(this.myAspectObserver).onChange((Enum)Range.Aspect.RANGE, this::contentsChanged);
    }

    private void captureStateChanged() {
        this.removeAllElements();
        CpuCapture capture = this.myStage.getCapture();
        if (capture != null && capture.getSystemTraceData() != null) {
            this.addElement(new FrameState("Main", capture.getMainThreadId(), SystemTraceFrame.FrameThread.MAIN, capture.getSystemTraceData(), this.myRange));
            this.addElement(new FrameState("Render", capture.getSystemTraceData().getRenderThreadId(), SystemTraceFrame.FrameThread.RENDER, capture.getSystemTraceData(), this.myRange));
        }
        this.contentsChanged();
    }

    private void contentsChanged() {
        this.fireContentsChanged(this, 0, this.getSize());
    }

    public static class FrameState {
        @NotNull
        private final DataSeries<SystemTraceFrame> myFrameDataSeries;
        @NotNull
        private final StateChartModel<SystemTraceFrame> myModel = new StateChartModel();
        private final String myThreadName;
        private final int myThreadId;

        public FrameState(String threadName, int threadId, @NotNull SystemTraceFrame.FrameThread threadType, @NotNull CpuSystemTraceData systemTraceData, @NotNull Range range) {
            this.myThreadName = threadName;
            this.myThreadId = threadId;
            this.myFrameDataSeries = new LazyDataSeries<SystemTraceFrame>(() -> systemTraceData.getFrames(threadType));
            this.myModel.addSeries(new RangedSeries(range, this.myFrameDataSeries));
        }

        public String getThreadName() {
            return this.myThreadName;
        }

        public int getThreadId() {
            return this.myThreadId;
        }

        @NotNull
        public DataSeries<SystemTraceFrame> getSeries() {
            return this.myFrameDataSeries;
        }

        @NotNull
        public StateChartModel<SystemTraceFrame> getModel() {
            return this.myModel;
        }
    }
}

