/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.config;

import com.android.tools.adtui.model.options.OptionsProperty;
import com.android.tools.adtui.model.options.OptionsProvider;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profilers.cpu.config.ArtInstrumentedConfiguration;
import com.android.tools.profilers.cpu.config.ArtSampledConfiguration;
import com.android.tools.profilers.cpu.config.AtraceConfiguration;
import com.android.tools.profilers.cpu.config.PerfettoConfiguration;
import com.android.tools.profilers.cpu.config.SimpleperfConfiguration;
import com.android.tools.profilers.cpu.config.UnspecifiedConfiguration;
import org.jetbrains.annotations.NotNull;

public abstract class ProfilingConfiguration
implements OptionsProvider {
    public static final String DEFAULT_CONFIGURATION_NAME = "Unnamed";
    public static final int DEFAULT_BUFFER_SIZE_MB = 8;
    public static final int DEFAULT_SAMPLING_INTERVAL_US = 1000;
    public static final String TRACE_CONFIG_GROUP = "Trace config";
    @NotNull
    private String myName;
    private boolean myDisableLiveAllocation = true;

    protected ProfilingConfiguration(@NotNull String name) {
        this.myName = name;
    }

    @NotNull
    public abstract Cpu.CpuTraceType getTraceType();

    @OptionsProperty(name="Configuration name: ", group="Trace config", order=99)
    @NotNull
    public String getName() {
        return this.myName;
    }

    @OptionsProperty
    public void setName(@NotNull String name) {
        this.myName = name;
    }

    @OptionsProperty(group="Performance", name="Live allocation tracking:", description="Live allocation tracking tracks allocated java objects. This can have an impact on overall app performance. It is recommended to disable this when recording a trace.")
    public boolean isDisableLiveAllocation() {
        return this.myDisableLiveAllocation;
    }

    @OptionsProperty
    public void setDisableLiveAllocation(boolean disableLiveAllocation) {
        this.myDisableLiveAllocation = disableLiveAllocation;
    }

    public abstract int getRequiredDeviceLevel();

    public boolean isDeviceLevelSupported(int deviceLevel) {
        return deviceLevel >= this.getRequiredDeviceLevel();
    }

    @NotNull
    public static ProfilingConfiguration fromProto(@NotNull Cpu.CpuTraceConfiguration.UserOptions proto) {
        ProfilingConfiguration configuration = null;
        switch (proto.getTraceType()) {
            case ART: {
                if (proto.getTraceMode() == Cpu.CpuTraceMode.SAMPLED) {
                    ArtSampledConfiguration artSampled = new ArtSampledConfiguration(proto.getName());
                    artSampled.setProfilingSamplingIntervalUs(proto.getSamplingIntervalUs());
                    artSampled.setProfilingBufferSizeInMb(proto.getBufferSizeInMb());
                    configuration = artSampled;
                    break;
                }
                ArtInstrumentedConfiguration art = new ArtInstrumentedConfiguration(proto.getName());
                art.setProfilingBufferSizeInMb(proto.getBufferSizeInMb());
                configuration = art;
                break;
            }
            case PERFETTO: {
                PerfettoConfiguration perfetto = new PerfettoConfiguration(proto.getName());
                perfetto.setProfilingBufferSizeInMb(proto.getBufferSizeInMb());
                configuration = perfetto;
                break;
            }
            case ATRACE: {
                AtraceConfiguration atrace = new AtraceConfiguration(proto.getName());
                atrace.setProfilingBufferSizeInMb(proto.getBufferSizeInMb());
                configuration = atrace;
                break;
            }
            case SIMPLEPERF: {
                SimpleperfConfiguration simpleperf = new SimpleperfConfiguration(proto.getName());
                simpleperf.setProfilingSamplingIntervalUs(proto.getSamplingIntervalUs());
                configuration = simpleperf;
                break;
            }
            case UNRECOGNIZED: 
            case UNSPECIFIED_TYPE: {
                return new UnspecifiedConfiguration(DEFAULT_CONFIGURATION_NAME);
            }
        }
        configuration.setDisableLiveAllocation(proto.getDisableLiveAllocation());
        return configuration;
    }

    @NotNull
    public Cpu.CpuTraceConfiguration.UserOptions toProto() {
        return this.buildUserOptions().setName(this.getName()).setTraceType(this.getTraceType()).setDisableLiveAllocation(this.isDisableLiveAllocation()).build();
    }

    protected abstract Cpu.CpuTraceConfiguration.UserOptions.Builder buildUserOptions();

    public boolean equals(Object obj) {
        if (!(obj instanceof ProfilingConfiguration)) {
            return false;
        }
        ProfilingConfiguration incoming = (ProfilingConfiguration)obj;
        return incoming.toProto().equals((Object)this.toProto());
    }

    public int hashCode() {
        return this.toProto().hashCode();
    }
}

