/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.capturedetails;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.instructions.InstructionsPanel;
import com.android.tools.adtui.instructions.NewRowInstruction;
import com.android.tools.adtui.instructions.RenderInstruction;
import com.android.tools.adtui.instructions.TextInstruction;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.stdui.StandardColors;
import com.android.tools.profilers.ProfilerFonts;
import com.android.tools.profilers.cpu.CpuProfilerAspect;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.CpuProfilerStageView;
import com.android.tools.profilers.cpu.ProfilingTechnology;
import com.android.tools.profilers.cpu.capturedetails.CapturePane;
import com.android.tools.profilers.cpu.config.CpuProfilingConfigurationView;
import com.android.tools.profilers.cpu.config.ProfilingConfiguration;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtilities;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

class RecordingInitiatorPane
extends CapturePane {
    @VisibleForTesting
    static final String HELP_TIP_TITLE = "Thread details unavailable";
    @VisibleForTesting
    static final String LEARN_MORE_MESSAGE = "Learn more";
    private static final String CONFIGURATIONS_URL = "https://d.android.com/r/studio-ui/profiler/cpu-recording-mode";
    @NotNull
    private final CpuProfilingConfigurationView myConfigsView;
    @NotNull
    private final JButton myRecordButton;
    @NotNull
    private final AspectObserver myObserver;

    RecordingInitiatorPane(@NotNull CpuProfilerStageView stageView) {
        super(stageView);
        this.myConfigsView = new CpuProfilingConfigurationView((CpuProfilerStage)stageView.getStage(), stageView.getIdeComponents());
        this.myRecordButton = new JButton("Record");
        this.myRecordButton.setEnabled(((CpuProfilerStage)stageView.getStage()).getStudioProfilers().getSessionsManager().isSessionAlive());
        this.myRecordButton.addActionListener(event -> ((CpuProfilerStage)stageView.getStage()).toggleCapturing());
        this.disableInteraction();
        this.updateView();
        this.myObserver = new AspectObserver();
        ((CpuProfilerStage)stageView.getStage()).getAspect().addDependency(this.myObserver).onChange((Enum)CpuProfilerAspect.PROFILING_CONFIGURATION, this::updateView);
    }

    @Override
    void populateContent(@NotNull JPanel panel2) {
        if (!((CpuProfilerStage)this.myStageView.getStage()).getStudioProfilers().getIdeServices().getFeatureConfig().isCpuNewRecordingWorkflowEnabled()) {
            panel2.add((Component)this.createHelpTipInstructions(), "Center");
            return;
        }
        JPanel content = new JPanel((LayoutManager)new TabularLayout("*,Fit,Fit,*", "*,Fit,Fit,Fit,Fit,*").setVGap(JBUI.scale((int)10)));
        JLabel label = new JLabel("Select CPU Profiling mode");
        label.setFont(ProfilerFonts.H2_FONT);
        label.setForeground(StandardColors.TEXT_COLOR);
        HyperlinkLabel technologyDescription = new HyperlinkLabel();
        ProfilingConfiguration config = ((CpuProfilerStage)this.myStageView.getStage()).getProfilerConfigModel().getProfilingConfiguration();
        technologyDescription.setHyperlinkText(ProfilingTechnology.fromConfig(config).getDescription(), "", "");
        technologyDescription.setForeground(StandardColors.TEXT_COLOR);
        HyperlinkLabel learnMore = new HyperlinkLabel();
        learnMore.setHyperlinkText(LEARN_MORE_MESSAGE);
        learnMore.setHyperlinkTarget(CONFIGURATIONS_URL);
        JPanel learnMoreCell = new JPanel((LayoutManager)new TabularLayout("Fit,*", "Fit").setVGap(JBUI.scale((int)10)));
        learnMoreCell.add((Component)learnMore, new TabularLayout.Constraint(0, 0));
        content.add((Component)label, new TabularLayout.Constraint(1, 1));
        content.add((Component)this.myConfigsView.getComponent(), new TabularLayout.Constraint(2, 1));
        content.add((Component)this.myRecordButton, new TabularLayout.Constraint(2, 2));
        content.add((Component)technologyDescription, new TabularLayout.Constraint(3, 1, 3));
        content.add((Component)learnMoreCell, new TabularLayout.Constraint(4, 1));
        panel2.add((Component)content, "Center");
    }

    @NotNull
    private JComponent createHelpTipInstructions() {
        FontMetrics headerMetrics = UIUtilities.getFontMetrics((JComponent)this, (Font)ProfilerFonts.H3_FONT);
        FontMetrics bodyMetrics = UIUtilities.getFontMetrics((JComponent)this, (Font)ProfilerFonts.STANDARD_FONT);
        return new InstructionsPanel.Builder(new RenderInstruction[]{new TextInstruction(headerMetrics, HELP_TIP_TITLE), new NewRowInstruction(NewRowInstruction.DEFAULT_ROW_MARGIN), new TextInstruction(bodyMetrics, "Click Record to start capturing CPU activity"), new NewRowInstruction(NewRowInstruction.DEFAULT_ROW_MARGIN), new TextInstruction(bodyMetrics, "or select a capture in the timeline.")}).setColors(JBColor.foreground(), null).build();
    }
}

