/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.capturedetails;

import com.android.tools.adtui.chart.hchart.HTreeChart;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.capturedetails.ChartDetailsView;
import com.android.tools.profilers.stacktrace.CodeLocation;
import com.android.tools.profilers.stacktrace.CodeNavigator;
import com.intellij.ui.DoubleClickListener;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CodeNavigationHandler
extends MouseAdapter {
    @NotNull
    private final HTreeChart<CaptureNode> myChart;
    private Point myLastPopupPoint;

    public CodeNavigationHandler(@NotNull HTreeChart<CaptureNode> chart, final @NotNull CodeNavigator navigator) {
        this.myChart = chart;
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent event) {
                CodeNavigationHandler.this.setLastPopupPoint(event);
                CodeLocation codeLocation = CodeNavigationHandler.this.getCodeLocation();
                if (codeLocation != null) {
                    navigator.navigate(codeLocation);
                }
                return false;
            }
        }.installOn(chart);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.handlePopup(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.handlePopup(e);
    }

    private void handlePopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.setLastPopupPoint(e);
        }
    }

    private void setLastPopupPoint(MouseEvent e) {
        this.myLastPopupPoint = e.getPoint();
    }

    @Nullable
    public CodeLocation getCodeLocation() {
        CaptureNode n = (CaptureNode)this.myChart.getNodeAt(this.myLastPopupPoint);
        if (n == null) {
            return null;
        }
        return ChartDetailsView.modelToCodeLocation(n.getData());
    }
}

