/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.capturedetails;

import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.filter.Filter;
import com.android.tools.adtui.model.filter.FilterResult;
import com.android.tools.perflib.vmtrace.ClockType;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.CpuProfilerAspect;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.capturedetails.CaptureDetails;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaptureModel {
    private static final double EPSILON = 1.0E-5;
    public static final int NO_THREAD = -1;
    private static final Map<CaptureDetails.Type, Consumer<FeatureTracker>> DETAILS_TRACKERS = ImmutableMap.of((Object)((Object)CaptureDetails.Type.TOP_DOWN), FeatureTracker::trackSelectCaptureTopDown, (Object)((Object)CaptureDetails.Type.BOTTOM_UP), FeatureTracker::trackSelectCaptureBottomUp, (Object)((Object)CaptureDetails.Type.CALL_CHART), FeatureTracker::trackSelectCaptureCallChart, (Object)((Object)CaptureDetails.Type.FLAME_CHART), FeatureTracker::trackSelectCaptureFlameChart);
    @NotNull
    private final CpuProfilerStage myStage;
    @Nullable
    private CpuCapture myCapture;
    private int myThread;
    @NotNull
    private ClockType myClockType = ClockType.GLOBAL;
    @NotNull
    private Filter myFilter = Filter.EMPTY_FILTER;
    @NotNull
    private FilterResult myFilterResult = FilterResult.EMPTY_RESULT;
    @Nullable
    private CaptureDetails myDetails;
    private final Range myCaptureConvertedRange;

    public CaptureModel(@NotNull CpuProfilerStage stage) {
        this.myStage = stage;
        this.myCaptureConvertedRange = new Range();
        this.myThread = -1;
        Range selection2 = this.myStage.getTimeline().getSelectionRange();
        selection2.addDependency(this.myStage.getAspect()).onChange((Enum)Range.Aspect.RANGE, this::updateCaptureConvertedRange);
        this.myCaptureConvertedRange.addDependency(this.myStage.getAspect()).onChange((Enum)Range.Aspect.RANGE, this::updateSelectionRange);
    }

    public boolean setCapture(@Nullable CpuCapture capture) {
        if (this.myCapture == capture) {
            return false;
        }
        this.myCapture = capture;
        if (this.myCapture != null) {
            this.setThread(this.myThread != -1 ? this.myThread : capture.getMainThreadId());
            if (this.myCapture.isDualClock()) {
                this.setClockType(this.myClockType);
            } else {
                this.setClockType(ClockType.GLOBAL);
            }
        } else {
            this.setThread(-1);
        }
        this.rebuildDetails();
        this.myStage.getAspect().changed((Enum)CpuProfilerAspect.CAPTURE_SELECTION);
        return true;
    }

    @Nullable
    public CpuCapture getCapture() {
        return this.myCapture;
    }

    public void setThread(int thread2) {
        if (this.myThread == thread2) {
            return;
        }
        this.myThread = thread2;
        this.rebuildDetails();
        this.myStage.getAspect().changed((Enum)CpuProfilerAspect.SELECTED_THREADS);
    }

    public int getThread() {
        return this.myThread;
    }

    public void setClockType(@NotNull ClockType type) {
        if (this.myClockType == type || this.myCapture != null && !this.myCapture.isDualClock() && type == ClockType.THREAD) {
            return;
        }
        this.myClockType = type;
        if (this.myCapture != null) {
            this.myCapture.updateClockType(this.myClockType);
        }
        this.rebuildDetails();
        this.updateCaptureConvertedRange();
        this.myStage.getAspect().changed((Enum)CpuProfilerAspect.CLOCK_TYPE);
    }

    @NotNull
    public ClockType getClockType() {
        return this.myClockType;
    }

    @NotNull
    public FilterResult applyFilter(@NotNull Filter filter) {
        if (Objects.equals(filter, this.myFilter)) {
            return this.myFilterResult;
        }
        this.myFilter = filter;
        this.rebuildDetails();
        return this.myFilterResult;
    }

    @NotNull
    public Filter getFilter() {
        return this.myFilter;
    }

    public void setDetails(@Nullable CaptureDetails.Type type) {
        if (type != null && this.myDetails != null && type == this.myDetails.getType()) {
            return;
        }
        FeatureTracker tracker = this.myStage.getStudioProfilers().getIdeServices().getFeatureTracker();
        if (type != null) {
            DETAILS_TRACKERS.get((Object)type).accept(tracker);
        }
        this.rebuildDetails(type);
    }

    @Nullable
    public CaptureDetails getDetails() {
        return this.myDetails;
    }

    private void rebuildDetails(@Nullable CaptureDetails.Type suggestedType) {
        this.updateCaptureConvertedRange();
        if (this.myCapture != null) {
            CaptureNode node = this.getNode();
            if (node != null) {
                this.myFilterResult = node.applyFilter(this.myFilter);
            }
            if (suggestedType == null) {
                suggestedType = this.myDetails == null ? CaptureDetails.Type.CALL_CHART : this.myDetails.getType();
            }
            List<CaptureNode> nodes = node == null ? Collections.emptyList() : Collections.singletonList(node);
            this.myDetails = suggestedType.build(this.myCaptureConvertedRange, nodes, this.myCapture);
        } else {
            this.myFilter = Filter.EMPTY_FILTER;
            this.myDetails = null;
        }
        this.myStage.getAspect().changed((Enum)CpuProfilerAspect.CAPTURE_DETAILS);
    }

    private void rebuildDetails() {
        this.rebuildDetails(null);
    }

    @Nullable
    private CaptureNode getNode() {
        return this.myCapture != null ? this.myCapture.getCaptureNode(this.myThread) : null;
    }

    private void updateCaptureConvertedRange() {
        CaptureNode node;
        Range selection2 = this.myStage.getTimeline().getSelectionRange();
        ClockType clockType = this.getClockType();
        CpuCapture capture = this.getCapture();
        if (clockType == ClockType.GLOBAL || capture == null || (node = capture.getCaptureNode(this.getThread())) == null) {
            this.setConvertedRange(selection2.getMin(), selection2.getMax());
            return;
        }
        double convertedMin = (double)node.getStartThread() + node.threadGlobalRatio() * (selection2.getMin() - (double)node.getStartGlobal());
        double convertedMax = convertedMin + node.threadGlobalRatio() * selection2.getLength();
        this.setConvertedRange(convertedMin, convertedMax);
    }

    private void updateSelectionRange() {
        CaptureNode node;
        ClockType clockType = this.getClockType();
        CpuCapture capture = this.getCapture();
        if (clockType == ClockType.GLOBAL || capture == null || (node = capture.getCaptureNode(this.getThread())) == null) {
            this.setSelectionRange(this.myCaptureConvertedRange.getMin(), this.myCaptureConvertedRange.getMax());
            return;
        }
        double threadToGlobal = 1.0 / node.threadGlobalRatio();
        double convertedMin = (double)node.getStartGlobal() + threadToGlobal * (this.myCaptureConvertedRange.getMin() - (double)node.getStartThread());
        double convertedMax = convertedMin + threadToGlobal * this.myCaptureConvertedRange.getLength();
        this.setSelectionRange(convertedMin, convertedMax);
    }

    private void setSelectionRange(double min, double max) {
        Range selection2 = this.myStage.getTimeline().getSelectionRange();
        if (Math.abs(selection2.getMin() - min) > 1.0E-5 || Math.abs(selection2.getMax() - max) > 1.0E-5) {
            selection2.set(min, max);
        }
    }

    private void setConvertedRange(double min, double max) {
        if (Math.abs(this.myCaptureConvertedRange.getMin() - min) > 1.0E-5 || Math.abs(this.myCaptureConvertedRange.getMax() - max) > 1.0E-5) {
            this.myCaptureConvertedRange.set(min, max);
        }
    }
}

