/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.capturedetails;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.VisualNodeCaptureNode;
import com.android.tools.profilers.cpu.capturedetails.BottomUpNode;
import com.android.tools.profilers.cpu.capturedetails.BottomUpTreeModel;
import com.android.tools.profilers.cpu.capturedetails.TopDownNode;
import com.android.tools.profilers.cpu.capturedetails.TopDownTreeModel;
import com.android.tools.profilers.cpu.nodemodel.SingleNameModel;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CaptureDetails {
    @NotNull
    private final CpuCapture myCapture;

    protected CaptureDetails(@NotNull CpuCapture cpuCapture) {
        this.myCapture = cpuCapture;
    }

    @NotNull
    public CpuCapture getCapture() {
        return this.myCapture;
    }

    @NotNull
    public abstract Type getType();

    public static class FlameChart
    extends ChartDetails {
        @NotNull
        private final Range myFlameRange;
        @Nullable
        private CaptureNode myFlameNode;
        @Nullable
        private final TopDownNode myTopDownNode;
        @NotNull
        private final Range mySelectionRange;
        @NotNull
        private final AspectModel<Aspect> myAspectModel;

        FlameChart(@NotNull Range selectionRange, @NotNull List<CaptureNode> captureNodes, @NotNull CpuCapture cpuCapture) {
            super(cpuCapture);
            this.mySelectionRange = selectionRange;
            this.myFlameRange = new Range();
            this.myAspectModel = new AspectModel();
            if (captureNodes.isEmpty()) {
                this.myFlameNode = null;
                this.myTopDownNode = null;
                return;
            }
            VisualNodeCaptureNode visual = new VisualNodeCaptureNode(new SingleNameModel(""));
            captureNodes.sort(Comparator.comparingLong(CaptureNode::getStartGlobal));
            captureNodes.forEach(visual::addChild);
            visual.setStartGlobal(captureNodes.get(0).getStartGlobal());
            this.myTopDownNode = new TopDownNode(visual);
            this.myTopDownNode.update(new Range(0.0, Double.MAX_VALUE));
            visual.setEndGlobal(visual.getStartGlobal() + (long)this.myTopDownNode.getGlobalChildrenTotal());
            selectionRange.addDependency(this.myAspectModel).onChange((Enum)Range.Aspect.RANGE, this::selectionRangeChanged);
            this.selectionRangeChanged();
        }

        private void selectionRangeChanged() {
            assert (this.myTopDownNode != null);
            this.myTopDownNode.update(this.mySelectionRange);
            if (this.myTopDownNode.getGlobalTotal() > 0.0) {
                double start = Math.max((double)this.myTopDownNode.getNodes().get(0).getStart(), this.mySelectionRange.getMin());
                this.myFlameNode = this.convertToFlameChart(this.myTopDownNode, start, 0);
                this.myFlameNode.setEndGlobal(((CaptureNode)this.myFlameNode.getLastChild()).getEndGlobal());
                this.myFlameRange.set((double)this.myFlameNode.getStart(), (double)this.myFlameNode.getEnd());
            } else {
                this.myFlameNode = null;
            }
            this.myAspectModel.changed((Enum)Aspect.NODE);
        }

        @NotNull
        public Range getRange() {
            return this.myFlameRange;
        }

        @Override
        @Nullable
        public CaptureNode getNode() {
            return this.myFlameNode;
        }

        @NotNull
        public AspectModel<Aspect> getAspect() {
            return this.myAspectModel;
        }

        @Override
        @NotNull
        public Type getType() {
            return Type.FLAME_CHART;
        }

        private CaptureNode convertToFlameChart(@NotNull TopDownNode topDown, double start, int depth) {
            assert (topDown.getGlobalTotal() > 0.0);
            CaptureNode node = new CaptureNode(topDown.getNodes().get(0).getData());
            node.setFilterType(topDown.getNodes().get(0).getFilterType());
            node.setStartGlobal((long)start);
            node.setStartThread((long)start);
            node.setEndGlobal((long)(start + topDown.getGlobalTotal()));
            node.setEndThread((long)(start + topDown.getThreadTotal()));
            node.setDepth(depth);
            for (TopDownNode child : topDown.getChildren()) {
                child.update(this.mySelectionRange);
            }
            ArrayList sortedChildren = new ArrayList(topDown.getChildren());
            sortedChildren.sort((o1, o2) -> {
                int cmp = Boolean.compare(o1.isUnmatched(), o2.isUnmatched());
                return cmp == 0 ? Double.compare(o2.getGlobalTotal(), o1.getGlobalTotal()) : cmp;
            });
            for (TopDownNode child : sortedChildren) {
                if (child.getGlobalTotal() == 0.0) continue;
                node.addChild(this.convertToFlameChart(child, start, depth + 1));
                start += child.getGlobalTotal();
            }
            return node;
        }

        public static enum Aspect {
            NODE;

        }
    }

    public static class CallChart
    extends ChartDetails {
        @NotNull
        private final Range myRange;
        @Nullable
        private CaptureNode myNode;

        public CallChart(@NotNull Range range, @NotNull List<CaptureNode> nodes, @NotNull CpuCapture cpuCapture) {
            super(cpuCapture);
            this.myRange = range;
            if (nodes.isEmpty()) {
                this.myNode = null;
                return;
            }
            this.myNode = nodes.get(0);
        }

        @NotNull
        public Range getRange() {
            return this.myRange;
        }

        @Override
        @Nullable
        public CaptureNode getNode() {
            return this.myNode;
        }

        @Override
        @NotNull
        public Type getType() {
            return Type.CALL_CHART;
        }
    }

    public static class BottomUp
    extends CaptureDetails {
        @Nullable
        private BottomUpTreeModel myModel;

        BottomUp(@NotNull Range range, @NotNull List<CaptureNode> nodes, @NotNull CpuCapture cpuCapture) {
            super(cpuCapture);
            if (nodes.isEmpty()) {
                this.myModel = null;
                return;
            }
            Range captureRange = cpuCapture.getRange();
            VisualNodeCaptureNode visual = new VisualNodeCaptureNode(new SingleNameModel(""));
            nodes.forEach(visual::addChild);
            visual.setStartGlobal((long)captureRange.getMin());
            visual.setEndGlobal((long)captureRange.getMax());
            BottomUpNode buNode = new BottomUpNode(visual);
            buNode.update(range);
            this.myModel = new BottomUpTreeModel(range, buNode);
        }

        @Nullable
        public BottomUpTreeModel getModel() {
            return this.myModel;
        }

        @Override
        @NotNull
        public Type getType() {
            return Type.BOTTOM_UP;
        }
    }

    public static class TopDown
    extends CaptureDetails {
        @Nullable
        private final TopDownTreeModel myModel;

        TopDown(@NotNull Range range, @NotNull List<CaptureNode> nodes, @NotNull CpuCapture cpuCapture) {
            super(cpuCapture);
            if (nodes.isEmpty()) {
                this.myModel = null;
                return;
            }
            Range captureRange = cpuCapture.getRange();
            VisualNodeCaptureNode visual = new VisualNodeCaptureNode(new SingleNameModel(""));
            nodes.forEach(visual::addChild);
            visual.setStartGlobal((long)captureRange.getMin());
            visual.setEndGlobal((long)captureRange.getMax());
            this.myModel = new TopDownTreeModel(range, new TopDownNode(visual));
        }

        @Nullable
        public TopDownTreeModel getModel() {
            return this.myModel;
        }

        @Override
        @NotNull
        public Type getType() {
            return Type.TOP_DOWN;
        }
    }

    static abstract class ChartDetails
    extends CaptureDetails {
        protected ChartDetails(@NotNull CpuCapture cpuCapture) {
            super(cpuCapture);
        }

        @Nullable
        abstract CaptureNode getNode();
    }

    static interface CaptureDetailsBuilder {
        public CaptureDetails build(Range var1, List<CaptureNode> var2, CpuCapture var3);
    }

    public static enum Type {
        TOP_DOWN(TopDown::new),
        BOTTOM_UP(BottomUp::new),
        CALL_CHART(CallChart::new),
        FLAME_CHART(FlameChart::new);

        @NotNull
        private final CaptureDetailsBuilder myBuilder;

        private Type(CaptureDetailsBuilder builder) {
            this.myBuilder = builder;
        }

        public CaptureDetails build(@NotNull Range range, @NotNull List<CaptureNode> node, @NotNull CpuCapture cpuCapture) {
            return this.myBuilder.build(range, node, cpuCapture);
        }
    }
}

