/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.capturedetails;

import com.android.tools.adtui.model.Range;
import com.android.tools.profilers.cpu.capturedetails.BottomUpNode;
import com.android.tools.profilers.cpu.capturedetails.CpuTreeModel;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;

public class BottomUpTreeModel
extends CpuTreeModel<BottomUpNode> {
    public BottomUpTreeModel(@NotNull Range range, @NotNull BottomUpNode node) {
        super(range, node);
    }

    @Override
    public void expand(@NotNull DefaultMutableTreeNode node) {
        BottomUpNode bottomUpNode = (BottomUpNode)node.getUserObject();
        boolean treeChanged = false;
        for (int i2 = 0; i2 < node.getChildCount(); ++i2) {
            Object child = (DefaultMutableTreeNode)node.getChildAt(i2);
            BottomUpNode childBottomUp = (BottomUpNode)((DefaultMutableTreeNode)child).getUserObject();
            if (!childBottomUp.buildChildren()) continue;
            treeChanged = true;
            this.loadChildren((DefaultMutableTreeNode)child);
        }
        for (Object child : bottomUpNode.getChildren()) {
            ((BottomUpNode)child).buildChildren();
        }
        if (treeChanged) {
            this.getAspect().changed((Enum)CpuTreeModel.Aspect.TREE_MODEL);
        }
    }

    private void loadChildren(@NotNull DefaultMutableTreeNode node) {
        BottomUpNode bottomUpNode = (BottomUpNode)node.getUserObject();
        for (BottomUpNode child : bottomUpNode.getChildren()) {
            if (child.inRange(this.getRange())) {
                child.update(this.getRange());
                this.insertNodeInto(new DefaultMutableTreeNode(child), node, 0);
                continue;
            }
            child.reset();
        }
    }
}

