/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.analysis;

import com.android.tools.adtui.model.Range;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profilers.cpu.analysis.CaptureNodeAnalysisModel;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisSummaryTabModel;
import org.jetbrains.annotations.NotNull;

public class CaptureNodeAnalysisSummaryTabModel
extends CpuAnalysisSummaryTabModel<CaptureNodeAnalysisModel> {
    @NotNull
    private final Cpu.CpuTraceType myTraceType;

    public CaptureNodeAnalysisSummaryTabModel(@NotNull Range captureRange, @NotNull Cpu.CpuTraceType traceType) {
        super(captureRange);
        this.myTraceType = traceType;
    }

    @Override
    @NotNull
    public String getLabel() {
        switch (this.myTraceType) {
            case ATRACE: 
            case PERFETTO: {
                return "Trace Event";
            }
        }
        return "Stack Frame";
    }

    @Override
    @NotNull
    public Range getSelectionRange() {
        Range selectionRange = new Range();
        for (CaptureNodeAnalysisModel analysisModel : this.getDataSeries()) {
            if (analysisModel.getNodeRange().getMin() < selectionRange.getMin()) {
                selectionRange.setMin(analysisModel.getNodeRange().getMin());
            }
            if (!(analysisModel.getNodeRange().getMax() > selectionRange.getMax())) continue;
            selectionRange.setMax(analysisModel.getNodeRange().getMax());
        }
        return selectionRange;
    }
}

