/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.chart.statechart.StateChart;
import com.android.tools.adtui.chart.statechart.StateChartColorProvider;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.StateChartModel;
import com.android.tools.profilers.FeatureConfig;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.cpu.CpuCellRenderer;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.systemtrace.CpuKernelModel;
import com.android.tools.profilers.cpu.systemtrace.CpuThreadSliceInfo;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import icons.StudioIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.jetbrains.annotations.NotNull;

public class CpuKernelCellRenderer
extends CpuCellRenderer<CpuKernelModel.CpuState, CpuThreadSliceInfo> {
    @NotNull
    private final CpuProfilerStage myStage;
    private final boolean myDebugRenderingEnabled;
    @VisibleForTesting
    final int myProcessId;

    public CpuKernelCellRenderer(@NotNull CpuProfilerStage stage, @NotNull FeatureConfig featureConfig, int processId, @NotNull JList<CpuKernelModel.CpuState> cpuStateList) {
        super(cpuStateList);
        this.myStage = stage;
        this.myProcessId = processId;
        this.myDebugRenderingEnabled = featureConfig.isPerformanceMonitoringEnabled();
    }

    @Override
    @NotNull
    StateChart<CpuThreadSliceInfo> getChartForModel(@NotNull CpuKernelModel.CpuState model) {
        return ((CpuCellRenderer.StateChartData)this.myStateCharts.get(model.getCpuId())).getChart();
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends CpuKernelModel.CpuState> list, CpuKernelModel.CpuState value, int index, boolean isSelected, boolean cellHasFocus) {
        JPanel panel2 = new JPanel((LayoutManager)new TabularLayout("150px,*", "*"));
        panel2.setBorder(ProfilerLayout.CPU_THREADS_BORDER);
        panel2.setPreferredSize((Dimension)JBDimension.create((Dimension)panel2.getPreferredSize()).withHeight(21));
        panel2.setBackground(list.getBackground());
        this.myLabel.setText(String.format("CPU %d", value.getCpuId()));
        this.myLabel.setBackground(ProfilerColors.THREAD_LABEL_BACKGROUND);
        this.myLabel.setForeground(ProfilerColors.THREAD_LABEL_TEXT);
        JBEmptyBorder iconIndent = JBUI.Borders.emptyLeft((int)(StudioIcons.LayoutEditor.Menu.MENU.getIconWidth() + this.myLabel.getIconTextGap()));
        this.myLabel.setBorder(new CompoundBorder((Border)iconIndent, ProfilerLayout.CPU_THREADS_RIGHT_BORDER));
        int cpuId = value.getCpuId();
        StateChartModel<CpuThreadSliceInfo> model = value.getModel();
        StateChart<CpuThreadSliceInfo> stateChart = this.getOrCreateStateChart(cpuId, model);
        stateChart.setDrawDebugInfo(this.myDebugRenderingEnabled);
        stateChart.setOpaque(true);
        panel2.add((Component)this.myLabel, new TabularLayout.Constraint(0, 0));
        panel2.add((Component)stateChart, new TabularLayout.Constraint(0, 0, 2));
        return panel2;
    }

    private StateChart<CpuThreadSliceInfo> getOrCreateStateChart(int cpuId, StateChartModel<CpuThreadSliceInfo> model) {
        if (this.myStateCharts.containsKey(cpuId) && ((CpuCellRenderer.StateChartData)this.myStateCharts.get(cpuId)).getModel().equals(model)) {
            return ((CpuCellRenderer.StateChartData)this.myStateCharts.get(cpuId)).getChart();
        }
        StateChart stateChart = new StateChart(model, (StateChartColorProvider)new StateChartColorProvider<CpuThreadSliceInfo>(){

            @NotNull
            public Color getColor(boolean isMouseOver, @NotNull CpuThreadSliceInfo value) {
                boolean isSelected;
                if (value == CpuThreadSliceInfo.NULL_THREAD) {
                    return ProfilerColors.DEFAULT_BACKGROUND;
                }
                if (value.getProcessId() != CpuKernelCellRenderer.this.myProcessId) {
                    return isMouseOver ? ProfilerColors.CPU_KERNEL_OTHER_HOVER : ProfilerColors.CPU_KERNEL_OTHER;
                }
                boolean bl = isSelected = CpuKernelCellRenderer.this.myStage.getSelectedThread() == value.getId();
                if (isMouseOver) {
                    return ProfilerColors.CPU_KERNEL_APP_HOVER;
                }
                if (isSelected) {
                    return ProfilerColors.CPU_KERNEL_APP_SELECTED;
                }
                return ProfilerColors.CPU_KERNEL_APP;
            }

            @NotNull
            public Color getFontColor(boolean isMouseOver, @NotNull CpuThreadSliceInfo value) {
                boolean isSelected;
                if (value == CpuThreadSliceInfo.NULL_THREAD) {
                    return AdtUiUtils.DEFAULT_FONT_COLOR;
                }
                if (value.getProcessId() != CpuKernelCellRenderer.this.myProcessId) {
                    return isMouseOver ? ProfilerColors.CPU_KERNEL_OTHER_TEXT_HOVER : ProfilerColors.CPU_KERNEL_OTHER_TEXT;
                }
                boolean bl = isSelected = CpuKernelCellRenderer.this.myStage.getSelectedThread() == value.getId();
                if (isMouseOver) {
                    return ProfilerColors.CPU_KERNEL_APP_TEXT_HOVER;
                }
                if (isSelected) {
                    return ProfilerColors.CPU_KERNEL_APP_TEXT_SELECTED;
                }
                return ProfilerColors.CPU_KERNEL_APP_TEXT;
            }
        }, threadInfo -> threadInfo.getName());
        stateChart.setRenderMode(StateChart.RenderMode.TEXT);
        CpuCellRenderer.StateChartData<CpuThreadSliceInfo> data = new CpuCellRenderer.StateChartData<CpuThreadSliceInfo>(stateChart, model);
        stateChart.setHeightGap(0.0f);
        this.myStateCharts.put(cpuId, data);
        return stateChart;
    }
}

