/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.chart.statechart.StateChart;
import com.android.tools.adtui.chart.statechart.StateChartColorProvider;
import com.android.tools.adtui.chart.statechart.StateChartTextConverter;
import com.android.tools.adtui.model.StateChartModel;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.profilers.FeatureConfig;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.cpu.CpuCellRenderer;
import com.android.tools.profilers.cpu.systemtrace.CpuFramesModel;
import com.android.tools.profilers.cpu.systemtrace.SystemTraceFrame;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import icons.StudioIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.jetbrains.annotations.NotNull;

public class CpuFramesCellRenderer
extends CpuCellRenderer<CpuFramesModel.FrameState, SystemTraceFrame> {
    private final boolean myDebugRenderingEnabled;
    private SystemTraceFrame myHighlightedFrame = SystemTraceFrame.EMPTY;
    private JList<CpuFramesModel.FrameState> myCpuStates;

    public CpuFramesCellRenderer(@NotNull FeatureConfig featureConfig, @NotNull JList<CpuFramesModel.FrameState> cpuStateList) {
        super(cpuStateList);
        this.myCpuStates = cpuStateList;
        this.myDebugRenderingEnabled = featureConfig.isPerformanceMonitoringEnabled();
    }

    @Override
    @NotNull
    StateChart<SystemTraceFrame> getChartForModel(@NotNull CpuFramesModel.FrameState model) {
        return ((CpuCellRenderer.StateChartData)this.myStateCharts.get(model.getModel().hashCode())).getChart();
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends CpuFramesModel.FrameState> list, CpuFramesModel.FrameState value, int index, boolean isSelected, boolean cellHasFocus) {
        JPanel panel2 = new JPanel((LayoutManager)new TabularLayout("150px,*", "*"));
        panel2.setBorder(ProfilerLayout.CPU_THREADS_BORDER);
        panel2.setPreferredSize((Dimension)JBDimension.create((Dimension)panel2.getPreferredSize()).withHeight(21));
        panel2.setBackground(list.getBackground());
        this.myLabel.setText(value.getThreadName());
        this.myLabel.setBackground(ProfilerColors.THREAD_LABEL_BACKGROUND);
        this.myLabel.setForeground(ProfilerColors.THREAD_LABEL_TEXT);
        JBEmptyBorder iconIndent = JBUI.Borders.emptyLeft((int)(StudioIcons.LayoutEditor.Menu.MENU.getIconWidth() + this.myLabel.getIconTextGap()));
        this.myLabel.setBorder(new CompoundBorder((Border)iconIndent, ProfilerLayout.CPU_THREADS_RIGHT_BORDER));
        StateChartModel<SystemTraceFrame> model = value.getModel();
        StateChart<SystemTraceFrame> stateChart = this.getOrCreateStateChart(model);
        stateChart.setDrawDebugInfo(this.myDebugRenderingEnabled);
        stateChart.setOpaque(true);
        panel2.add((Component)this.myLabel, new TabularLayout.Constraint(0, 0));
        panel2.add((Component)stateChart, new TabularLayout.Constraint(0, 0, 2));
        return panel2;
    }

    private void repaint() {
        this.myCpuStates.repaint();
    }

    void setHighlightedFrame(@NotNull SystemTraceFrame frame) {
        if (this.myHighlightedFrame != frame) {
            this.myHighlightedFrame = frame;
            this.repaint();
        }
    }

    private boolean isFrameHighlighted(@NotNull SystemTraceFrame frame) {
        if (this.myHighlightedFrame == SystemTraceFrame.EMPTY) {
            return false;
        }
        return frame == this.myHighlightedFrame || frame == this.myHighlightedFrame.getAssociatedFrame();
    }

    private StateChart<SystemTraceFrame> getOrCreateStateChart(StateChartModel<SystemTraceFrame> model) {
        if (this.myStateCharts.containsKey(model.hashCode()) && ((CpuCellRenderer.StateChartData)this.myStateCharts.get(model.hashCode())).getModel().equals(model)) {
            return ((CpuCellRenderer.StateChartData)this.myStateCharts.get(model.hashCode())).getChart();
        }
        StateChart stateChart = new StateChart(model, (StateChartColorProvider)new StateChartColorProvider<SystemTraceFrame>(){

            @NotNull
            public Color getColor(boolean isMouseOver, @NotNull SystemTraceFrame value) {
                boolean isHighlighted = CpuFramesCellRenderer.this.isFrameHighlighted(value);
                switch (value.getTotalPerfClass()) {
                    case BAD: {
                        return isHighlighted ? ProfilerColors.SLOW_FRAME_COLOR_HIGHLIGHTED : ProfilerColors.SLOW_FRAME_COLOR;
                    }
                    case GOOD: {
                        return isHighlighted ? ProfilerColors.NORMAL_FRAME_COLOR_HIGHLIGHTED : ProfilerColors.NORMAL_FRAME_COLOR;
                    }
                }
                return ProfilerColors.DEFAULT_STAGE_BACKGROUND;
            }
        }, (StateChartTextConverter)new StateChartTextConverter<SystemTraceFrame>(){

            @NotNull
            public String convertToString(@NotNull SystemTraceFrame value) {
                if (value.getTotalPerfClass() == SystemTraceFrame.PerfClass.BAD) {
                    return TimeFormatter.getSingleUnitDurationString((long)value.getDurationUs());
                }
                return "";
            }
        });
        stateChart.setRenderMode(StateChart.RenderMode.TEXT);
        CpuCellRenderer.StateChartData<SystemTraceFrame> data = new CpuCellRenderer.StateChartData<SystemTraceFrame>(stateChart, model);
        stateChart.setHeightGap(0.0f);
        this.myStateCharts.put(model.hashCode(), data);
        return stateChart;
    }
}

