/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.energy;

import com.android.tools.profiler.proto.Network;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public interface PowerProfile {
    public static final String GPS_PROVIDER = "gps";
    public static final String NETWORK_PROVIDER = "network";
    public static final String PASSIVE_PROVIDER = "passive";

    public int getCpuUsage(@NotNull CpuCoreUsage[] var1);

    public int getNetworkUsage(@NotNull NetworkStats var1);

    public int getLocationUsage(@NotNull LocationStats var1);

    public static final class LocationStats {
        public final LocationType myLocationType;
        public final long myDurationNs;
        public final long mySampleIntervalNs;

        public LocationStats(@NotNull LocationType type, long durationNs, long sampleIntervalNs) {
            this.myLocationType = type;
            this.myDurationNs = durationNs;
            this.mySampleIntervalNs = sampleIntervalNs;
        }
    }

    public static final class LocationEvent {
        public final long myEventId;
        public final LocationType myLocationType;

        public LocationEvent(long id, @NotNull LocationType type) {
            this.myEventId = id;
            this.myLocationType = type;
        }
    }

    public static final class NetworkStats {
        public final NetworkType myNetworkType;
        public final long myReceivingBps;
        public final long mySendingBps;

        public NetworkStats(NetworkType type, long receivingBps, long sendingBps) {
            this.myNetworkType = type;
            this.myReceivingBps = receivingBps;
            this.mySendingBps = sendingBps;
        }
    }

    public static final class CpuCoreUsage {
        public final double myAppUsage;
        public final double myCoreUsage;
        public final int myCoreId;
        public final int myMinFrequencyKhz;
        public final int myMaxFrequencyKhz;
        public final int myFrequencyKhz;
        public final boolean myIsLittleCore;

        public CpuCoreUsage(int coreId, double appUsage, double coreUsage, int minFrequencyKhz, int maxFrequencyKhz, int frequencyKhz, boolean isLittleCore) {
            this.myCoreId = coreId;
            this.myAppUsage = appUsage;
            this.myCoreUsage = coreUsage;
            this.myMinFrequencyKhz = minFrequencyKhz;
            this.myMaxFrequencyKhz = maxFrequencyKhz;
            this.myFrequencyKhz = frequencyKhz;
            this.myIsLittleCore = isLittleCore;
        }
    }

    public static final class DefaultPowerProfile
    implements PowerProfile {
        static final int MIN_CORE_FREQ_KHZ = 300000;
        static final int MAX_BIG_CORE_FREQ_KHZ = 2457600;
        static final int MAX_LITTLE_CORE_FREQ_KHZ = 0x1D0100;

        @Override
        public int getCpuUsage(@NotNull CpuCoreUsage[] usages) {
            if (usages.length == 0) {
                return 0;
            }
            double totalMilliAmps = 0.0;
            List<CpuCoreUsage> usagesList = Arrays.asList(usages);
            Collections.sort(usagesList, Comparator.comparingInt(o -> o.myMaxFrequencyKhz));
            boolean lowerClusterActivationAdded = false;
            boolean higherClusterActivationAdded = false;
            boolean cpuActivationAdded = false;
            for (CpuCoreUsage core : usagesList) {
                double fMhz = DefaultPowerProfile.renormalizeFrequency(core, core.myIsLittleCore ? 0x1D0100 : 2457600);
                double f2 = fMhz * fMhz;
                double f3 = f2 * fMhz;
                if (core.myAppUsage > 0.0) {
                    if (!cpuActivationAdded) {
                        cpuActivationAdded = true;
                        totalMilliAmps += 17.757;
                    }
                    if (core.myIsLittleCore && !lowerClusterActivationAdded) {
                        lowerClusterActivationAdded = true;
                        totalMilliAmps += 6.478;
                    } else if (!core.myIsLittleCore && !higherClusterActivationAdded) {
                        higherClusterActivationAdded = true;
                        totalMilliAmps += 6.141;
                    }
                }
                if (core.myIsLittleCore) {
                    totalMilliAmps += (5.79689E-9 * f3 - 8.31587E-6 * f2 + 0.0109841 * fMhz + 0.513398) * core.myAppUsage * core.myCoreUsage;
                    continue;
                }
                totalMilliAmps += (2.48408E-8 * f3 - 4.68129E-5 * f2 + 0.0551123 * fMhz - 1.96322) * core.myAppUsage * core.myCoreUsage;
            }
            return (int)totalMilliAmps;
        }

        @Override
        public int getNetworkUsage(@NotNull NetworkStats networkStats) {
            if (networkStats.myNetworkType != NetworkType.WIFI && networkStats.myNetworkType != NetworkType.RADIO) {
                return 0;
            }
            if (networkStats.myReceivingBps == 0L && networkStats.mySendingBps == 0L) {
                return 0;
            }
            int usage = 0;
            if (networkStats.myReceivingBps > 0L) {
                usage += networkStats.myNetworkType == NetworkType.WIFI ? DefaultPowerProfile.fitBps(1.0, 99.0, networkStats.myReceivingBps, 1000000L) : DefaultPowerProfile.fitBps(10.0, 40.0, networkStats.myReceivingBps, 200000L);
            }
            if (networkStats.mySendingBps > 0L) {
                usage += networkStats.myNetworkType == NetworkType.WIFI ? DefaultPowerProfile.fitBps(1.0, 249.0, networkStats.mySendingBps, 500000L) : DefaultPowerProfile.fitBps(10.0, 190.0, networkStats.mySendingBps, 200000L);
            }
            return usage;
        }

        @Override
        public int getLocationUsage(@NotNull LocationStats locationStats) {
            switch (locationStats.myLocationType) {
                case GPS: {
                    return (int)(90.0 * (double)locationStats.myDurationNs / (double)locationStats.mySampleIntervalNs);
                }
                case GPS_ACQUIRE: {
                    return 90;
                }
                case NETWORK: {
                    return (int)(30.0 * (double)locationStats.myDurationNs / (double)locationStats.mySampleIntervalNs);
                }
            }
            return 0;
        }

        @VisibleForTesting
        static double renormalizeFrequency(@NotNull CpuCoreUsage core, int maxFrequencyKhz) {
            double clampedFreq = Ints.constrainToRange((int)core.myFrequencyKhz, (int)core.myMinFrequencyKhz, (int)core.myMaxFrequencyKhz);
            return ((clampedFreq - (double)core.myMinFrequencyKhz) / (double)(core.myMaxFrequencyKhz - core.myMinFrequencyKhz) * (double)(maxFrequencyKhz - 300000) + 300000.0) * 0.001;
        }

        static int fitBps(double base, double scale, long bps, long normalizer) {
            return (int)(base + scale * (double)Longs.constrainToRange((long)bps, (long)0L, (long)normalizer) / (double)normalizer);
        }
    }

    public static enum LocationType {
        NONE,
        PASSIVE,
        NETWORK,
        GPS_ACQUIRE,
        GPS;


        @NotNull
        public static LocationType from(@NotNull String protoLocationProvider) {
            switch (protoLocationProvider) {
                case "gps": {
                    return GPS;
                }
                case "network": {
                    return NETWORK;
                }
                case "passive": {
                    return PASSIVE;
                }
            }
            return NONE;
        }
    }

    public static enum NetworkType {
        WIFI,
        RADIO,
        NONE;


        @NotNull
        public static NetworkType from(Network.NetworkTypeData.NetworkType protoNetworkType) {
            switch (protoNetworkType) {
                case MOBILE: {
                    return RADIO;
                }
                case WIFI: {
                    return WIFI;
                }
            }
            return NONE;
        }
    }
}

