/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.sequence.psi;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.util.TypeUtils;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.FlexibleType;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/sequence/psi/KotlinPsiUtil;", "", "()V", "getTypeName", "", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "getTypeWithoutTypeParameters", "kotlin.jvm-debugger.sequence"})
public final class KotlinPsiUtil {
    @NotNull
    public static final KotlinPsiUtil INSTANCE;

    @NotNull
    public final String getTypeName(@NotNull KotlinType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (type instanceof FlexibleType) {
            return DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(TypeUtils.approximateFlexibleTypes$default((KotlinType)type, (boolean)false, (boolean)false, (int)3, null));
        }
        return DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(type);
    }

    @NotNull
    public final String getTypeWithoutTypeParameters(@NotNull KotlinType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        ClassifierDescriptor classifierDescriptor = type.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            return this.getTypeName(type);
        }
        Intrinsics.checkNotNullExpressionValue((Object)classifierDescriptor, (String)"type.constructor.declara\u2026 return getTypeName(type)");
        ClassifierDescriptor descriptor = classifierDescriptor;
        String string = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)descriptor)).asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"descriptor.fqNameSafe.asString()");
        return string;
    }

    private KotlinPsiUtil() {
    }

    static {
        KotlinPsiUtil kotlinPsiUtil;
        INSTANCE = kotlinPsiUtil = new KotlinPsiUtil();
    }
}

