/*
 * Decompiled with CFR 0.152.
 */
package git4idea.update;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.update.UpdateSession;
import com.intellij.util.containers.MultiMap;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.update.GitUpdateInfoAsLog;
import git4idea.update.GitUpdateSession;
import git4idea.update.GitUpdateSessionKt;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0002\u0010\fJ\n\u0010\r\u001a\u0004\u0018\u00010\u000bH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J(\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\n0\u00122\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u0002J\b\u0010\u0013\u001a\u00020\u0007H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J'\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\b\u0010\u001b\u001a\u0004\u0018\u00010\u0019H\u0002\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\u0015H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lgit4idea/update/GitUpdateSession;", "Lcom/intellij/openapi/vcs/update/UpdateSession;", "project", "Lcom/intellij/openapi/project/Project;", "notificationData", "Lgit4idea/update/GitUpdateInfoAsLog$NotificationData;", "result", "", "skippedRoots", "", "Lgit4idea/repo/GitRepository;", "", "(Lcom/intellij/openapi/project/Project;Lgit4idea/update/GitUpdateInfoAsLog$NotificationData;ZLjava/util/Map;)V", "getAdditionalNotificationContent", "getExceptions", "", "Lcom/intellij/openapi/vcs/VcsException;", "groupByReasons", "Lcom/intellij/util/containers/MultiMap;", "isCanceled", "onRefreshFilesCompleted", "", "prepareNotification", "Lcom/intellij/notification/Notification;", "updatedFilesNumber", "", "updatedCommitsNumber", "filteredCommitsNumber", "(IILjava/lang/Integer;)Lcom/intellij/notification/Notification;", "showNotification", "intellij.vcs.git"})
public final class GitUpdateSession
implements UpdateSession {
    private final Project project;
    private final GitUpdateInfoAsLog.NotificationData notificationData;
    private final boolean result;
    private final Map<GitRepository, String> skippedRoots;

    @NotNull
    public List<VcsException> getExceptions() {
        return CollectionsKt.emptyList();
    }

    public void onRefreshFilesCompleted() {
    }

    public boolean isCanceled() {
        return !this.result;
    }

    @Nullable
    public String getAdditionalNotificationContent() {
        if (this.skippedRoots.isEmpty()) {
            return null;
        }
        if (this.skippedRoots.size() == 1) {
            GitRepository repo = (GitRepository)CollectionsKt.first((Iterable)this.skippedRoots.keySet());
            return GitBundle.message("git.update.repo.was.skipped", DvcsUtil.getShortRepositoryName((Repository)repo), this.skippedRoots.get(repo));
        }
        String prefix = GitBundle.message("git.update.skipped.repositories", this.skippedRoots.size()) + " <br/>";
        MultiMap<String, GitRepository> grouped = this.groupByReasons(this.skippedRoots);
        if (grouped.keySet().size() == 1) {
            String reason = (String)CollectionsKt.first((Iterable)grouped.keySet());
            return prefix + DvcsUtil.getShortNames((Collection)grouped.get((Object)reason)) + " (" + reason + ")";
        }
        return prefix + CollectionsKt.joinToString$default((Iterable)grouped.keySet(), (CharSequence)"<br/>", null, null, (int)0, null, (Function1)((Function1)new Function1<String, CharSequence>(grouped){
            final /* synthetic */ MultiMap $grouped;

            @NotNull
            public final CharSequence invoke(String reason) {
                return DvcsUtil.getShortNames((Collection)this.$grouped.get((Object)reason)) + " (" + reason + ")";
            }
            {
                this.$grouped = multiMap;
                super(1);
            }
        }), (int)30, null);
    }

    /*
     * WARNING - void declaration
     */
    private final MultiMap<String, GitRepository> groupByReasons(Map<GitRepository, String> skippedRoots) {
        MultiMap result2 = MultiMap.create();
        Map<GitRepository, String> $this$forEach$iv = skippedRoots;
        boolean $i$f$forEach = false;
        Map<GitRepository, String> map2 = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<GitRepository, String>> iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            void file;
            Map.Entry<GitRepository, String> element$iv;
            Map.Entry<GitRepository, String> $dstr$file$s = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry<GitRepository, String> entry = $dstr$file$s;
            boolean bl3 = false;
            GitRepository gitRepository = entry.getKey();
            entry = $dstr$file$s;
            bl3 = false;
            String s = entry.getValue();
            result2.putValue((Object)s, (Object)file);
        }
        return result2;
    }

    public void showNotification() {
        if (this.notificationData != null) {
            Notification notification = this.prepareNotification(this.notificationData.getUpdatedFilesCount(), this.notificationData.getReceivedCommitsCount(), this.notificationData.getFilteredCommitsCount());
            notification.addAction((AnAction)NotificationAction.createSimple((Supplier)showNotification.1.INSTANCE, (Runnable)this.notificationData.getViewCommitAction()));
            VcsNotifier.getInstance((Project)this.project).notify(notification);
        }
    }

    private final Notification prepareNotification(int updatedFilesNumber, int updatedCommitsNumber, Integer filteredCommitsNumber) {
        String title = null;
        String content = null;
        NotificationType type = null;
        String mainMessage = GitUpdateSessionKt.getTitleForUpdateNotification(updatedFilesNumber, updatedCommitsNumber);
        if (this.isCanceled()) {
            title = GitBundle.message("git.update.project.partially.updated.title", new Object[0]);
            content = mainMessage;
            type = NotificationType.WARNING;
        } else {
            title = mainMessage;
            content = GitUpdateSessionKt.getBodyForUpdateNotification(filteredCommitsNumber);
            type = NotificationType.INFORMATION;
        }
        String additionalContent = this.getAdditionalNotificationContent();
        if (additionalContent != null) {
            CharSequence charSequence = content;
            boolean bl = false;
            if (charSequence.length() > 0) {
                content = content + "<br/>";
            }
            content = content + additionalContent;
        }
        return VcsNotifier.STANDARD_NOTIFICATION.createNotification(title, content, type, null);
    }

    public GitUpdateSession(@NotNull Project project, @Nullable GitUpdateInfoAsLog.NotificationData notificationData, boolean result2, @NotNull Map<GitRepository, String> skippedRoots) {
        this.project = project;
        this.notificationData = notificationData;
        this.result = result2;
        this.skippedRoots = skippedRoots;
    }
}

