/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch.dashboard;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.util.DataPackUtilKt;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.branch.GitBranchType;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.branch.GitBranchManager;
import git4idea.ui.branch.dashboard.BranchInfo;
import git4idea.ui.branch.dashboard.BranchesDashboardUtil;
import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010\n\u001a\u00020\u000bJ\"\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0015\u001a\u00020\u0016J\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0015\u001a\u00020\u0016J.\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00130\u0004H\u0002\u00a8\u0006\u001b"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardUtil;", "", "()V", "checkIsMyBranchesSynchronously", "", "Lgit4idea/ui/branch/dashboard/BranchInfo;", "log", "Lcom/intellij/vcs/log/impl/VcsProjectLog;", "branchesToCheck", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "findExclusiveCommits", "Lgnu/trove/TIntHashSet;", "branchName", "", "repo", "Lgit4idea/repo/GitRepository;", "findMyCommits", "", "getLocalBranches", "project", "Lcom/intellij/openapi/project/Project;", "getRemoteBranches", "isMyBranch", "", "myCommits", "intellij.vcs.git"})
public final class BranchesDashboardUtil {
    public static final BranchesDashboardUtil INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<BranchInfo> getLocalBranches(@NotNull Project project) {
        void $this$mapTo$iv$iv;
        boolean bl = false;
        Map localMap = new LinkedHashMap();
        for (GitRepository repo : GitRepositoryManager.getInstance(project).getRepositories()) {
            for (GitLocalBranch branch : repo.getBranches().getLocalBranches()) {
                ((Set)localMap.computeIfAbsent(branch.getName(), getLocalBranches.1.INSTANCE)).add(repo);
            }
            GitLocalBranch currentBranch = repo.getCurrentBranch();
            if (currentBranch == null) continue;
            ((Set)localMap.computeIfAbsent(currentBranch.getName(), getLocalBranches.2.INSTANCE)).add(repo);
        }
        Project $this$service$iv = project;
        boolean $i$f$service = false;
        GitBranchManager gitBranchManager = (GitBranchManager)((Object)$this$service$iv.getService(GitBranchManager.class));
        Map $this$map$iv = localMap;
        boolean $i$f$map = false;
        Map map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var10_15 = $this$mapTo$iv$iv;
        boolean bl2 = false;
        Iterator iterator = var10_15.entrySet().iterator();
        while (iterator.hasNext()) {
            boolean bl3;
            Object object;
            Object object2;
            Collection collection;
            block10: {
                void $this$any$iv;
                boolean bl4;
                void var21_26;
                void branchName;
                boolean bl5;
                Set repos;
                boolean bl6;
                block9: {
                    void $this$any$iv2;
                    void $dstr$branchName$repos;
                    Map.Entry item$iv$iv;
                    Map.Entry entry = item$iv$iv = iterator.next();
                    collection = destination$iv$iv;
                    boolean bl7 = false;
                    object2 = $dstr$branchName$repos;
                    bl6 = false;
                    String string = (String)object2.getKey();
                    object2 = $dstr$branchName$repos;
                    bl6 = false;
                    repos = (Set)object2.getValue();
                    object2 = repos;
                    bl5 = true;
                    var21_26 = branchName;
                    boolean $i$f$any = false;
                    if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                        bl4 = false;
                    } else {
                        for (Object element$iv : $this$any$iv2) {
                            GitRepository it = (GitRepository)element$iv;
                            boolean bl8 = false;
                            GitLocalBranch gitLocalBranch = it.getCurrentBranch();
                            if (!Intrinsics.areEqual((Object)(gitLocalBranch != null ? gitLocalBranch.getName() : null), (Object)branchName)) continue;
                            bl4 = true;
                            break block9;
                        }
                        bl4 = false;
                    }
                }
                boolean bl9 = bl4;
                List list = CollectionsKt.toList((Iterable)repos);
                boolean bl10 = bl9;
                boolean bl11 = bl5;
                void var41_47 = var21_26;
                object2 = new BranchInfo((String)var41_47, bl11, bl10, list);
                bl6 = false;
                boolean bl12 = false;
                Object $this$apply = object2;
                boolean bl13 = false;
                Iterable bl8 = repos;
                object = $this$apply;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl3 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        GitRepository it = (GitRepository)element$iv;
                        boolean bl14 = false;
                        if (!gitBranchManager.isFavorite(GitBranchType.LOCAL, it, (String)branchName)) continue;
                        bl3 = true;
                        break block10;
                    }
                    bl3 = false;
                }
            }
            boolean bl15 = bl3;
            ((BranchInfo)object).setFavorite(bl15);
            Object object3 = object2;
            collection.add(object3);
        }
        HashSet local = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
        return local;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<BranchInfo> getRemoteBranches(@NotNull Project project) {
        void $this$mapTo$iv$iv;
        boolean bl = false;
        Map remoteMap = new LinkedHashMap();
        for (GitRepository repo : GitRepositoryManager.getInstance(project).getRepositories()) {
            for (GitRemoteBranch remoteBranch : repo.getBranches().getRemoteBranches()) {
                ((List)remoteMap.computeIfAbsent(remoteBranch.getName(), getRemoteBranches.1.INSTANCE)).add(repo);
            }
        }
        Project $this$service$iv = project;
        boolean $i$f$service = false;
        GitBranchManager gitBranchManager = (GitBranchManager)((Object)$this$service$iv.getService(GitBranchManager.class));
        Map $this$map$iv = remoteMap;
        boolean $i$f$map = false;
        Map map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var9_12 = $this$mapTo$iv$iv;
        boolean bl2 = false;
        Iterator iterator = var9_12.entrySet().iterator();
        while (iterator.hasNext()) {
            boolean bl3;
            BranchInfo branchInfo;
            BranchInfo branchInfo2;
            Collection collection;
            block6: {
                void $this$any$iv;
                void branchName;
                void $dstr$branchName$repos;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                collection = destination$iv$iv;
                boolean bl4 = false;
                branchInfo2 = $dstr$branchName$repos;
                boolean bl5 = false;
                String string = (String)branchInfo2.getKey();
                branchInfo2 = $dstr$branchName$repos;
                bl5 = false;
                List repos = (List)branchInfo2.getValue();
                branchInfo2 = new BranchInfo((String)branchName, false, false, repos);
                bl5 = false;
                boolean bl6 = false;
                BranchInfo $this$apply = branchInfo2;
                boolean bl7 = false;
                Iterable iterable = repos;
                branchInfo = $this$apply;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl3 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        GitRepository it = (GitRepository)element$iv;
                        boolean bl8 = false;
                        if (!gitBranchManager.isFavorite(GitBranchType.REMOTE, it, (String)branchName)) continue;
                        bl3 = true;
                        break block6;
                    }
                    bl3 = false;
                }
            }
            boolean bl9 = bl3;
            branchInfo.setFavorite(bl9);
            BranchInfo branchInfo3 = branchInfo2;
            collection.add(branchInfo3);
        }
        return CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<BranchInfo> checkIsMyBranchesSynchronously(@NotNull VcsProjectLog log, @NotNull Collection<BranchInfo> branchesToCheck, @NotNull ProgressIndicator indicator) {
        Set<Integer> myCommits = this.findMyCommits(log);
        Collection collection = myCommits;
        boolean bl = false;
        boolean bl2 = false;
        if (collection == null || collection.isEmpty()) {
            return SetsKt.emptySet();
        }
        indicator.setIndeterminate(false);
        bl = false;
        HashSet<BranchInfo> myBranches = new HashSet<BranchInfo>();
        bl = false;
        for (BranchInfo branch : (Iterable)branchesToCheck) {
            void step;
            indicator.setFraction((double)step / (double)branchesToCheck.size());
            for (GitRepository repo : branch.getRepositories()) {
                indicator.checkCanceled();
                if (!this.isMyBranch(log, branch.getBranchName(), repo, myCommits)) continue;
                myBranches.add(branch);
            }
            ++step;
        }
        return myBranches;
    }

    private final Set<Integer> findMyCommits(VcsProjectLog log) {
        Collection collection = CollectionsKt.listOf((Object)"*");
        VcsLogData vcsLogData = log.getDataManager();
        if (vcsLogData == null) {
            Intrinsics.throwNpe();
        }
        VcsLogUserFilter filterByMe = VcsLogFilterObject.fromUserNames((Collection)collection, (VcsLogData)vcsLogData);
        VcsLogData vcsLogData2 = log.getDataManager();
        if (vcsLogData2 == null) {
            Intrinsics.throwNpe();
        }
        IndexDataGetter indexDataGetter = vcsLogData2.getIndex().getDataGetter();
        if (indexDataGetter == null) {
            Intrinsics.throwNpe();
        }
        return indexDataGetter.filter(CollectionsKt.listOf((Object)filterByMe));
    }

    private final boolean isMyBranch(VcsProjectLog log, String branchName, GitRepository repo, Set<Integer> myCommits) {
        TIntHashSet tIntHashSet = this.findExclusiveCommits(log, branchName, repo);
        if (tIntHashSet == null) {
            return false;
        }
        TIntHashSet exclusiveCommits = tIntHashSet;
        if (exclusiveCommits.isEmpty()) {
            return false;
        }
        for (int commit2 : exclusiveCommits) {
            if (myCommits.contains(commit2)) continue;
            return false;
        }
        return true;
    }

    private final TIntHashSet findExclusiveCommits(VcsProjectLog log, String branchName, GitRepository repo) {
        VcsLogData vcsLogData = log.getDataManager();
        if (vcsLogData == null) {
            Intrinsics.throwNpe();
        }
        DataPack dataPack = vcsLogData.getDataPack();
        VcsRef vcsRef = DataPackUtilKt.findBranch((DataPack)dataPack, (String)branchName, (VirtualFile)repo.getRoot());
        if (vcsRef == null) {
            return null;
        }
        VcsRef ref = vcsRef;
        if (!ref.getType().isBranch()) {
            return null;
        }
        RefsModel refsModel = dataPack.getRefsModel();
        VcsLogData vcsLogData2 = log.getDataManager();
        if (vcsLogData2 == null) {
            Intrinsics.throwNpe();
        }
        return DataPackUtilKt.exclusiveCommits((DataPack)dataPack, (VcsRef)ref, (RefsModel)refsModel, (VcsLogStorage)vcsLogData2.getStorage());
    }

    private BranchesDashboardUtil() {
    }

    static {
        BranchesDashboardUtil branchesDashboardUtil;
        INSTANCE = branchesDashboardUtil = new BranchesDashboardUtil();
    }
}

