/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.VcsRepositoryMappingListener;
import com.intellij.dvcs.ui.DvcsStatusWidget;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.StatusBarWidgetFactory;
import com.intellij.openapi.wm.impl.status.widget.StatusBarWidgetsManager;
import com.intellij.ui.LayeredIcon;
import git4idea.GitUtil;
import git4idea.branch.GitBranchIncomingOutgoingManager;
import git4idea.branch.GitBranchUtil;
import git4idea.config.GitVcsSettings;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.branch.GitBranchPopup;
import icons.DvcsImplIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitBranchWidget
extends DvcsStatusWidget<GitRepository> {
    private static final Icon INCOMING_LAYERED = new LayeredIcon(new Icon[]{AllIcons.Vcs.Branch, DvcsImplIcons.IncomingLayer});
    private static final Icon INCOMING_OUTGOING_LAYERED = new LayeredIcon(new Icon[]{AllIcons.Vcs.Branch, DvcsImplIcons.IncomingOutgoingLayer});
    private static final Icon OUTGOING_LAYERED = new LayeredIcon(new Icon[]{AllIcons.Vcs.Branch, DvcsImplIcons.OutgoingLayer});
    private static final String ID = "git";
    private final GitVcsSettings mySettings;

    public GitBranchWidget(@NotNull Project project) {
        super(project, "Git");
        this.mySettings = GitVcsSettings.getInstance(project);
        project.getMessageBus().connect((Disposable)this).subscribe(GitRepository.GIT_REPO_CHANGE, r -> this.updateLater());
        project.getMessageBus().connect((Disposable)this).subscribe(GitBranchIncomingOutgoingManager.GIT_INCOMING_OUTGOING_CHANGED, () -> ((GitBranchWidget)this).updateLater());
    }

    @NotNull
    public String ID() {
        return ID;
    }

    public StatusBarWidget copy() {
        return new GitBranchWidget(this.getProject());
    }

    @Nullable
    protected GitRepository guessCurrentRepository(@NotNull Project project) {
        return (GitRepository)DvcsUtil.guessCurrentRepositoryQuick((Project)project, (AbstractRepositoryManager)GitUtil.getRepositoryManager(project), (String)this.mySettings.getRecentRootPath());
    }

    @Nullable
    protected Icon getIcon(@NotNull GitRepository repository) {
        String currentBranchName = repository.getCurrentBranchName();
        if (repository.getState() == Repository.State.NORMAL && currentBranchName != null) {
            GitRepository indicatorRepo = GitRepositoryManager.getInstance(this.myProject).moreThanOneRoot() && this.mySettings.getSyncSetting() == DvcsSyncSettings.Value.DONT_SYNC ? repository : null;
            boolean hasIncoming = GitBranchIncomingOutgoingManager.getInstance(this.myProject).hasIncomingFor(indicatorRepo, currentBranchName);
            boolean hasOutgoing = GitBranchIncomingOutgoingManager.getInstance(this.myProject).hasOutgoingFor(indicatorRepo, currentBranchName);
            if (hasIncoming) {
                return hasOutgoing ? INCOMING_OUTGOING_LAYERED : INCOMING_LAYERED;
            }
            if (hasOutgoing) {
                return OUTGOING_LAYERED;
            }
        }
        return super.getIcon((Repository)repository);
    }

    @NotNull
    protected String getFullBranchName(@NotNull GitRepository repository) {
        return GitBranchUtil.getDisplayableBranchText(repository);
    }

    protected boolean isMultiRoot(@NotNull Project project) {
        return !GitUtil.justOneGitRepository(project);
    }

    @NotNull
    protected ListPopup getPopup(@NotNull Project project, @NotNull GitRepository repository) {
        return GitBranchPopup.getInstance(project, repository).asListPopup();
    }

    protected void rememberRecentRoot(@NotNull String path) {
        this.mySettings.setRecentRoot(path);
    }

    public static class Factory
    implements StatusBarWidgetFactory {
        @NotNull
        public String getId() {
            return GitBranchWidget.ID;
        }

        @Nls
        @NotNull
        public String getDisplayName() {
            return GitBundle.message("git.status.bar.widget.name", new Object[0]);
        }

        public boolean isAvailable(@NotNull Project project) {
            return !Registry.is((String)"vcs.new.widget") && !GitRepositoryManager.getInstance(project).getRepositories().isEmpty();
        }

        @NotNull
        public StatusBarWidget createWidget(@NotNull Project project) {
            return new GitBranchWidget(project);
        }

        public void disposeWidget(@NotNull StatusBarWidget widget) {
            Disposer.dispose((Disposable)widget);
        }

        public boolean canBeEnabledOn(@NotNull StatusBar statusBar) {
            return true;
        }
    }

    public static class Listener
    implements VcsRepositoryMappingListener {
        private final Project myProject;

        public Listener(@NotNull Project project) {
            this.myProject = project;
        }

        public void mappingChanged() {
            ((StatusBarWidgetsManager)this.myProject.getService(StatusBarWidgetsManager.class)).updateWidget(Factory.class);
        }
    }
}

