/*
 * Decompiled with CFR 0.152.
 */
package git4idea.roots;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.roots.VcsIntegrationEnabler;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitVcs;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.i18n.GitBundle;
import org.jetbrains.annotations.NotNull;

public final class GitIntegrationEnabler
extends VcsIntegrationEnabler {
    private static final Logger LOG = Logger.getInstance(GitIntegrationEnabler.class);

    public GitIntegrationEnabler(@NotNull GitVcs vcs) {
        super((AbstractVcs)vcs);
    }

    protected boolean initOrNotifyError(@NotNull VirtualFile projectDir) {
        VcsNotifier vcsNotifier = VcsNotifier.getInstance((Project)this.myProject);
        GitCommandResult result2 = Git.getInstance().init(this.myProject, projectDir, new GitLineHandlerListener[0]);
        if (result2.success()) {
            GitIntegrationEnabler.refreshVcsDir((VirtualFile)projectDir, (String)".git");
            vcsNotifier.notifySuccess(GitBundle.message("git.integration.created.git.repository.in", projectDir.getPresentableUrl()));
            return true;
        }
        vcsNotifier.notifyError(GitBundle.message("git.integration.could.not.git.init", projectDir.getPresentableUrl()), result2.getErrorOutputAsHtmlString(), true);
        LOG.info(result2.getErrorOutputAsHtmlString());
        return false;
    }
}

