/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rollback;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vcs.rollback.RollbackProgressListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.repo.GitUntrackedFilesHolder;
import git4idea.util.GitFileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Service
public final class GitRollbackEnvironment
implements RollbackEnvironment {
    @NotNull
    private final Project myProject;

    public GitRollbackEnvironment(@NotNull Project project) {
        this.myProject = project;
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    @NotNull
    public String getRollbackOperationName() {
        return GitBundle.message("git.rollback", new Object[0]);
    }

    public void rollbackModifiedWithoutCheckout(@NotNull List<VirtualFile> files, List<VcsException> exceptions, RollbackProgressListener listener) {
        throw new UnsupportedOperationException("Explicit file checkout is not supported by Git.");
    }

    public void rollbackMissingFileDeletion(@NotNull List<FilePath> files, List<VcsException> exceptions, RollbackProgressListener listener) {
        throw new UnsupportedOperationException("Missing file delete is not reported by Git.");
    }

    public void rollbackIfUnchanged(@NotNull VirtualFile file) {
    }

    public void rollbackChanges(@NotNull List<Change> changes, @NotNull List<VcsException> exceptions, @NotNull RollbackProgressListener listener) {
        HashMap<VirtualFile, List<FilePath>> toUnindex = new HashMap<VirtualFile, List<FilePath>>();
        HashMap<VirtualFile, List<FilePath>> toUnversion = new HashMap<VirtualFile, List<FilePath>>();
        HashMap<VirtualFile, List<FilePath>> toRevert = new HashMap<VirtualFile, List<FilePath>>();
        ArrayList<FilePath> toDelete = new ArrayList<FilePath>();
        listener.determinate();
        for (Change change : changes) {
            switch (change.getType()) {
                case NEW: {
                    this.registerFile(toUnversion, change.getAfterRevision().getFile(), exceptions);
                    break;
                }
                case MOVED: {
                    this.registerFile(toRevert, change.getBeforeRevision().getFile(), exceptions);
                    this.registerFile(toUnindex, change.getAfterRevision().getFile(), exceptions);
                    toDelete.add(change.getAfterRevision().getFile());
                    break;
                }
                case MODIFICATION: {
                    this.registerFile(toRevert, change.getBeforeRevision().getFile(), exceptions);
                    break;
                }
                case DELETED: {
                    this.registerFile(toRevert, change.getBeforeRevision().getFile(), exceptions);
                }
            }
        }
        for (Map.Entry entry : toUnindex.entrySet()) {
            listener.accept((List)entry.getValue());
            try {
                this.unindex((VirtualFile)entry.getKey(), (List)entry.getValue(), false);
            }
            catch (VcsException e) {
                exceptions.add(e);
            }
        }
        for (Map.Entry entry : toUnversion.entrySet()) {
            listener.accept((List)entry.getValue());
            try {
                this.unindex((VirtualFile)entry.getKey(), (List)entry.getValue(), true);
            }
            catch (VcsException e) {
                exceptions.add(e);
            }
        }
        for (FilePath filePath : toDelete) {
            listener.accept(filePath);
            try {
                File ioFile = filePath.getIOFile();
                if (!ioFile.exists() || ioFile.delete()) continue;
                exceptions.add(new VcsException("Unable to delete file: " + filePath));
            }
            catch (Exception e) {
                exceptions.add(new VcsException("Unable to delete file: " + filePath, (Throwable)e));
            }
        }
        Throwable throwable = null;
        try (AccessToken ignore = DvcsUtil.workingTreeChangeStarted((Project)this.myProject, (String)this.getRollbackOperationName());){
            for (Map.Entry<VirtualFile, List<FilePath>> entry : toRevert.entrySet()) {
                listener.accept(entry.getValue());
                try {
                    this.revert(entry.getKey(), entry.getValue());
                }
                catch (VcsException e) {
                    exceptions.add(e);
                }
            }
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        HashSet<File> hashSet = new HashSet<File>();
        for (Change c : changes) {
            ContentRevision after2;
            ContentRevision before = c.getBeforeRevision();
            if (before != null) {
                hashSet.add(new File(before.getFile().getPath()));
            }
            if ((after2 = c.getAfterRevision()) == null) continue;
            hashSet.add(new File(after2.getFile().getPath()));
        }
        lfs.refreshIoFiles(hashSet);
        for (GitRepository repo : GitUtil.getRepositoryManager(this.myProject).getRepositories()) {
            repo.update();
        }
    }

    public void revert(@NotNull VirtualFile root, @NotNull List<? extends FilePath> files) throws VcsException {
        for (List paths : VcsFileUtil.chunkPaths((VirtualFile)root, files)) {
            GitLineHandler handler = new GitLineHandler(this.myProject, root, GitCommand.CHECKOUT);
            handler.addParameters("HEAD");
            handler.endOptions();
            handler.addParameters(paths);
            Git.getInstance().runCommand(handler).throwOnError(new int[0]);
        }
    }

    private void unindex(@NotNull VirtualFile root, @NotNull List<? extends FilePath> files, boolean toUnversioned) throws VcsException {
        GitFileUtils.deletePaths(this.myProject, root, files, "--cached", "-f");
        if (toUnversioned) {
            GitRepository repo = (GitRepository)GitUtil.getRepositoryManager(this.myProject).getRepositoryForRoot(root);
            GitUntrackedFilesHolder untrackedFilesHolder = repo == null ? null : repo.getUntrackedFilesHolder();
            for (FilePath filePath : files) {
                if (untrackedFilesHolder == null) continue;
                untrackedFilesHolder.add(filePath);
            }
        }
    }

    private void registerFile(@NotNull Map<VirtualFile, List<FilePath>> files, @NotNull FilePath file, @NotNull List<? super VcsException> exceptions) {
        try {
            VirtualFile root = GitUtil.getRootForFile(this.myProject, file);
            List paths = files.computeIfAbsent(root, key -> new ArrayList());
            paths.add(file);
        }
        catch (VcsException e) {
            exceptions.add(e);
        }
    }

    public static void resetHardLocal(@NotNull Project project, @NotNull VirtualFile root) {
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.RESET);
        handler.addParameters("--hard");
        handler.endOptions();
        Git.getInstance().runCommand(handler);
    }
}

