/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.dvcs.push.PushSpec;
import com.intellij.dvcs.push.Pusher;
import com.intellij.dvcs.push.VcsPushOptionValue;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import git4idea.GitUtil;
import git4idea.config.GitVcsSettings;
import git4idea.push.GitPushOperation;
import git4idea.push.GitPushResult;
import git4idea.push.GitPushResultNotification;
import git4idea.push.GitPushSource;
import git4idea.push.GitPushSupport;
import git4idea.push.GitPushTagMode;
import git4idea.push.GitPushTarget;
import git4idea.push.GitVcsPushOptionValue;
import git4idea.repo.GitRepository;
import git4idea.update.GitUpdateInfoAsLog;
import git4idea.update.HashRange;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitPusher
extends Pusher<GitRepository, GitPushSource, GitPushTarget> {
    @NotNull
    private final Project myProject;
    @NotNull
    private final GitVcsSettings mySettings;
    @NotNull
    private final GitPushSupport myPushSupport;

    GitPusher(@NotNull Project project, @NotNull GitVcsSettings settings, @NotNull GitPushSupport pushSupport) {
        this.myProject = project;
        this.mySettings = settings;
        this.myPushSupport = pushSupport;
    }

    public void push(@NotNull Map<GitRepository, PushSpec<GitPushSource, GitPushTarget>> pushSpecs, @Nullable VcsPushOptionValue optionValue, boolean force) {
        boolean skipHook;
        GitPushTagMode pushTagMode;
        this.expireExistingErrorsAndWarnings();
        if (optionValue instanceof GitVcsPushOptionValue) {
            pushTagMode = ((GitVcsPushOptionValue)optionValue).getPushTagMode();
            skipHook = ((GitVcsPushOptionValue)optionValue).isSkipHook();
        } else {
            pushTagMode = null;
            skipHook = false;
        }
        this.mySettings.setPushTagMode(pushTagMode);
        GitPushOperation pushOperation = new GitPushOperation(this.myProject, this.myPushSupport, pushSpecs, pushTagMode, force, skipHook);
        GitPusher.pushAndNotify(this.myProject, pushOperation);
    }

    public static void pushAndNotify(@NotNull Project project, @NotNull GitPushOperation pushOperation) {
        GitPushResult pushResult = pushOperation.execute();
        Map<GitRepository, HashRange> updatedRanges = pushResult.getUpdatedRanges();
        GitUpdateInfoAsLog.NotificationData notificationData = !updatedRanges.isEmpty() ? new GitUpdateInfoAsLog(project, updatedRanges).calculateDataAndCreateLogTab() : null;
        ApplicationManager.getApplication().invokeLater(() -> {
            boolean multiRepoProject = GitUtil.getRepositoryManager(project).moreThanOneRoot();
            GitPushResultNotification.create(project, pushResult, pushOperation, multiRepoProject, notificationData).notify(project);
        });
    }

    protected void expireExistingErrorsAndWarnings() {
        GitPushResultNotification[] existingNotifications;
        for (GitPushResultNotification notification : existingNotifications = (GitPushResultNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(GitPushResultNotification.class, this.myProject)) {
            if (notification.getType() == NotificationType.INFORMATION) continue;
            notification.expire();
        }
    }
}

