/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.dvcs.push.OutgoingCommitsProvider;
import com.intellij.dvcs.push.PushSettings;
import com.intellij.dvcs.push.PushSupport;
import com.intellij.dvcs.push.PushTargetPanel;
import com.intellij.dvcs.push.Pusher;
import com.intellij.dvcs.push.VcsPushOptionsPanel;
import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitStandardRemoteBranch;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUtil;
import git4idea.config.GitSharedSettings;
import git4idea.config.GitVcsSettings;
import git4idea.config.GitVersionSpecialty;
import git4idea.push.GitOutgoingCommitsProvider;
import git4idea.push.GitPushOptionsPanel;
import git4idea.push.GitPushSource;
import git4idea.push.GitPushTarget;
import git4idea.push.GitPushTargetPanel;
import git4idea.push.GitPusher;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitHooksInfo;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitPushSupport
extends PushSupport<GitRepository, GitPushSource, GitPushTarget> {
    @NotNull
    private final GitRepositoryManager myRepositoryManager;
    @NotNull
    private final GitVcs myVcs;
    @NotNull
    private final Pusher<GitRepository, GitPushSource, GitPushTarget> myPusher;
    @NotNull
    private final OutgoingCommitsProvider<GitRepository, GitPushSource, GitPushTarget> myOutgoingCommitsProvider;
    @NotNull
    private final GitVcsSettings mySettings;
    private final GitSharedSettings mySharedSettings;
    @NotNull
    private final PushSettings myCommonPushSettings;

    private GitPushSupport(@NotNull Project project) {
        this.myRepositoryManager = GitRepositoryManager.getInstance(project);
        this.myVcs = GitVcs.getInstance(project);
        this.mySettings = GitVcsSettings.getInstance(project);
        this.myPusher = new GitPusher(project, this.mySettings, this);
        this.myOutgoingCommitsProvider = new GitOutgoingCommitsProvider(project);
        this.mySharedSettings = (GitSharedSettings)ServiceManager.getService((Project)project, GitSharedSettings.class);
        this.myCommonPushSettings = (PushSettings)ServiceManager.getService((Project)project, PushSettings.class);
    }

    @NotNull
    public AbstractVcs getVcs() {
        return this.myVcs;
    }

    @NotNull
    public Pusher<GitRepository, GitPushSource, GitPushTarget> getPusher() {
        return this.myPusher;
    }

    @NotNull
    public OutgoingCommitsProvider<GitRepository, GitPushSource, GitPushTarget> getOutgoingCommitsProvider() {
        return this.myOutgoingCommitsProvider;
    }

    @Nullable
    public GitPushTarget getDefaultTarget(@NotNull GitRepository repository) {
        if (repository.isFresh()) {
            return null;
        }
        GitLocalBranch sourceBranch = repository.getCurrentBranch();
        if (sourceBranch == null) {
            return null;
        }
        return this.getDefaultTarget(repository, GitPushSource.create(sourceBranch));
    }

    @Nullable
    public GitPushTarget getDefaultTarget(@NotNull GitRepository repository, @NotNull GitPushSource source) {
        if (source instanceof GitPushSource.DetachedHead) {
            return null;
        }
        GitPushTarget pushSpecTarget = GitPushSupport.getPushTargetIfExist(repository, source.getBranch());
        if (pushSpecTarget != null) {
            return pushSpecTarget;
        }
        return GitPushSupport.proposeTargetForNewBranch(repository, source.getBranch());
    }

    @Nullable
    public static GitPushTarget getPushTargetIfExist(@NotNull GitRepository repository, @NotNull GitLocalBranch localBranch) {
        GitPushTarget pushSpecTarget = GitPushTarget.getFromPushSpec(repository, localBranch);
        if (pushSpecTarget != null) {
            return pushSpecTarget;
        }
        GitBranchTrackInfo trackInfo = GitBranchUtil.getTrackInfoForBranch(repository, localBranch);
        if (trackInfo != null) {
            return new GitPushTarget(trackInfo.getRemoteBranch(), false);
        }
        return null;
    }

    private static GitPushTarget proposeTargetForNewBranch(@NotNull GitRepository repository, @NotNull GitLocalBranch sourceBranch) {
        GitRemote remote = GitUtil.getDefaultOrFirstRemote(repository.getRemotes());
        if (remote == null) {
            return null;
        }
        return GitPushSupport.makeTargetForNewBranch(repository, remote, sourceBranch);
    }

    @NotNull
    private static GitPushTarget makeTargetForNewBranch(@NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull GitLocalBranch sourceBranch) {
        GitRemoteBranch existingRemoteBranch = GitUtil.findRemoteBranch(repository, remote, sourceBranch.getName());
        if (existingRemoteBranch != null) {
            return new GitPushTarget(existingRemoteBranch, false);
        }
        return new GitPushTarget(new GitStandardRemoteBranch(remote, sourceBranch.getName()), true);
    }

    @NotNull
    public GitPushSource getSource(@NotNull GitRepository repository) {
        GitLocalBranch currentBranch = repository.getCurrentBranch();
        return currentBranch != null ? GitPushSource.create(currentBranch) : GitPushSource.create(Objects.requireNonNull(repository.getCurrentRevision()));
    }

    @NotNull
    public RepositoryManager<GitRepository> getRepositoryManager() {
        return this.myRepositoryManager;
    }

    @NotNull
    public PushTargetPanel<GitPushTarget> createTargetPanel(@NotNull GitRepository repository, @NotNull GitPushSource source, @Nullable GitPushTarget defaultTarget) {
        return new GitPushTargetPanel(this, repository, source, defaultTarget);
    }

    public boolean isForcePushAllowed(@NotNull GitRepository repo, @NotNull GitPushTarget target) {
        String targetBranch = target.getBranch().getNameForRemoteOperations();
        return !this.mySharedSettings.isBranchProtected(targetBranch);
    }

    @Nullable
    public VcsPushOptionsPanel createOptionsPanel() {
        return new GitPushOptionsPanel(this.mySettings.getPushTagMode(), GitVersionSpecialty.SUPPORTS_FOLLOW_TAGS.existsIn(this.myVcs), this.shouldShowSkipHookOption());
    }

    private boolean shouldShowSkipHookOption() {
        return GitVersionSpecialty.PRE_PUSH_HOOK.existsIn(this.myVcs) && this.getRepositoryManager().getRepositories().stream().map(e -> e.getInfo().getHooksInfo()).anyMatch(GitHooksInfo::isPrePushHookAvailable);
    }

    public boolean isSilentForcePushAllowed(@NotNull GitPushTarget target) {
        return this.myCommonPushSettings.containsForcePushTarget(target.getBranch().getRemote().getName(), target.getBranch().getNameForRemoteOperations());
    }

    public void saveSilentForcePushTarget(@NotNull GitPushTarget target) {
        this.myCommonPushSettings.addForcePushTarget(target.getBranch().getRemote().getName(), target.getBranch().getNameForRemoteOperations());
    }

    public boolean mayChangeTargetsSync() {
        return true;
    }
}

