/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.update.AbstractCommonUpdateAction;
import com.intellij.openapi.vcs.update.ActionInfo;
import com.intellij.openapi.vcs.update.UpdateInfoTree;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.ViewUpdateInfoNotification;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUtil;
import git4idea.push.GitPushOperation;
import git4idea.push.GitPushRepoResult;
import git4idea.push.GitPushResult;
import git4idea.push.GitPusher;
import git4idea.push.GroupedPushResult;
import git4idea.repo.GitRepository;
import git4idea.update.GitUpdateInfoAsLog;
import git4idea.update.GitUpdateResult;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import one.util.streamex.EntryStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitPushResultNotification
extends Notification {
    public static final String VIEW_FILES_UPDATED_DURING_THE_PUSH = "View files updated during the push";
    public static final String UPDATE_WITH_RESOLVED_CONFLICTS = "push has been cancelled, because there were conflicts during update.<br/>Check that conflicts were resolved correctly, and invoke push again.";
    public static final String INCOMPLETE_UPDATE = "push has been cancelled, because not all conflicts were resolved during update.<br/>Resolve the conflicts and invoke push again.";
    public static final String UPDATE_WITH_ERRORS = "push was rejected, and update failed with error.";
    public static final String UPDATE_CANCELLED = "push was rejected, and update was cancelled.";
    private static final Logger LOG = Logger.getInstance(GitPushResultNotification.class);

    private GitPushResultNotification(@NotNull String groupDisplayId, @NotNull String title, @NotNull String content, @NotNull NotificationType type) {
        super(groupDisplayId, "", GitPushResultNotification.emulateTitle(title, content), type);
    }

    @NotNull
    static GitPushResultNotification create(@NotNull Project project, @NotNull GitPushResult pushResult, @Nullable GitPushOperation pushOperation, boolean multiRepoProject, @Nullable GitUpdateInfoAsLog.NotificationData notificationData) {
        List staleInfoRejected;
        String description;
        NotificationType type;
        String title;
        GroupedPushResult grouped = GroupedPushResult.group(pushResult.getResults());
        boolean singleRepoSuccess = false;
        if (!grouped.errors.isEmpty()) {
            title = !grouped.successful.isEmpty() ? "Push partially failed" : "Push failed";
            type = NotificationType.ERROR;
        } else if (!grouped.rejected.isEmpty() || !grouped.customRejected.isEmpty()) {
            title = !grouped.successful.isEmpty() ? "Push partially rejected" : "Push rejected";
            type = NotificationType.WARNING;
        } else {
            type = NotificationType.INFORMATION;
            if (!multiRepoProject) {
                singleRepoSuccess = true;
                GitPushRepoResult result3 = grouped.successful.values().iterator().next();
                title = StringUtil.capitalize((String)GitPushResultNotification.formRepoDescription(result3));
            } else {
                title = "Push successful";
            }
        }
        if (singleRepoSuccess) {
            if (notificationData != null) {
                int receivedCommitsCount = notificationData.getReceivedCommitsCount();
                description = String.format("%d %s received during the push", receivedCommitsCount, GitPushResultNotification.commits(receivedCommitsCount));
            } else {
                description = "";
            }
        } else {
            description = GitPushResultNotification.formDescription(pushResult.getResults(), multiRepoProject);
        }
        NotificationGroup group = type == NotificationType.INFORMATION ? VcsNotifier.STANDARD_NOTIFICATION : VcsNotifier.IMPORTANT_ERROR_NOTIFICATION;
        GitPushResultNotification notification = new GitPushResultNotification(group.getDisplayId(), title, description, type);
        if (AbstractCommonUpdateAction.showsCustomNotification(Collections.singletonList(GitVcs.getInstance(project)))) {
            if (notificationData != null && notificationData.getReceivedCommitsCount() > 0) {
                Integer filteredCommitsCount = notificationData.getFilteredCommitsCount();
                String actionText = filteredCommitsCount == null || filteredCommitsCount == 0 ? "View received " + GitPushResultNotification.commits(notificationData.getReceivedCommitsCount()) : String.format("View %d %s matching the filter", filteredCommitsCount, GitPushResultNotification.commits(filteredCommitsCount));
                notification.addAction((AnAction)NotificationAction.createSimple((String)actionText, (Runnable)notificationData.getViewCommitAction()));
            }
        } else {
            UpdateInfoTree tree;
            UpdatedFiles updatedFiles = pushResult.getUpdatedFiles();
            if (!updatedFiles.isEmpty() && (tree = ProjectLevelVcsManagerEx.getInstanceEx((Project)project).showUpdateProjectInfo(updatedFiles, "Update", ActionInfo.UPDATE, false)) != null) {
                tree.setBefore(pushResult.getBeforeUpdateLabel());
                tree.setAfter(pushResult.getAfterUpdateLabel());
                notification.addAction((AnAction)new ViewUpdateInfoNotification(project, tree, VIEW_FILES_UPDATED_DURING_THE_PUSH, (Notification)notification));
            }
        }
        if (!(staleInfoRejected = EntryStream.of(pushResult.getResults()).filterValues(result2 -> result2.getType() == GitPushRepoResult.Type.REJECTED_STALE_INFO).keys().toList()).isEmpty()) {
            notification.setContextHelpAction(new AnAction("What is force-with-lease?", "Force-with-lease push prevents overriding remote changes that are unknown to local repository.<br>Fetch latest changes to verify that they can be safely discarded and repeat push operation.", null){

                public void actionPerformed(@NotNull AnActionEvent e) {
                }
            });
            if (pushOperation != null) {
                notification.addAction((AnAction)new ForcePushNotificationAction(project, pushOperation, staleInfoRejected));
            }
        }
        if (Registry.is((String)"vcs.showConsole") && !grouped.errors.isEmpty() || !grouped.rejected.isEmpty() || !grouped.customRejected.isEmpty()) {
            notification.addAction((AnAction)NotificationAction.createSimple((String)VcsBundle.message((String)"notification.showDetailsInConsole", (Object[])new Object[0]), () -> {
                ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
                vcsManager.showConsole(() -> ((ProjectLevelVcsManager)vcsManager).scrollConsoleToTheEnd());
            }));
        }
        return notification;
    }

    @NotNull
    static String emulateTitle(@NotNull String title, @NotNull String content) {
        return "<b>" + title + "</b><br/>" + content;
    }

    @NotNull
    private static String commits(int commitsNumber) {
        return StringUtil.pluralize((String)"commit", (int)commitsNumber);
    }

    private static String formDescription(@NotNull Map<GitRepository, GitPushRepoResult> results, boolean multiRepoProject) {
        List entries = ContainerUtil.sorted(results.entrySet(), (o1, o2) -> {
            int compareResultTypes = GitPushRepoResult.TYPE_COMPARATOR.compare(((GitPushRepoResult)o1.getValue()).getType(), ((GitPushRepoResult)o2.getValue()).getType());
            if (compareResultTypes != 0) {
                return compareResultTypes;
            }
            return DvcsUtil.REPOSITORY_COMPARATOR.compare(o1.getKey(), o2.getKey());
        });
        return StringUtil.join((Collection)entries, entry -> {
            GitRepository repository = (GitRepository)entry.getKey();
            GitPushRepoResult result2 = (GitPushRepoResult)entry.getValue();
            String description = GitPushResultNotification.formRepoDescription(result2);
            description = !multiRepoProject ? StringUtil.capitalize((String)description) : DvcsUtil.getShortRepositoryName((Repository)repository) + ": " + description;
            return description;
        }, (String)"<br/>");
    }

    private static String formRepoDescription(@NotNull GitPushRepoResult result2) {
        String description;
        String sourceBranch = GitBranchUtil.stripRefsPrefix(result2.getSourceBranch());
        String targetBranch = GitBranchUtil.stripRefsPrefix(result2.getTargetBranch());
        String tagDescription = GitPushResultNotification.formTagDescription(result2.getPushedTags(), result2.getTargetRemote());
        switch (result2.getType()) {
            case SUCCESS: {
                int commitNum = result2.getNumberOfPushedCommits();
                String commits2 = StringUtil.pluralize((String)"commit", (int)commitNum);
                description = String.format("pushed %d %s to %s", commitNum, commits2, targetBranch);
                if (tagDescription == null) break;
                description = description + ", and " + tagDescription;
                break;
            }
            case NEW_BRANCH: {
                description = String.format("pushed %s to new branch %s", sourceBranch, targetBranch);
                if (tagDescription == null) break;
                description = description + ", and " + tagDescription;
                break;
            }
            case UP_TO_DATE: {
                if (tagDescription != null) {
                    description = "pushed " + tagDescription;
                    break;
                }
                description = "everything is up-to-date";
                break;
            }
            case FORCED: {
                description = String.format("force pushed %s to %s", sourceBranch, targetBranch);
                break;
            }
            case REJECTED_NO_FF: {
                description = GitPushResultNotification.formDescriptionBasedOnUpdateResult(result2.getUpdateResult(), targetBranch);
                break;
            }
            case REJECTED_STALE_INFO: {
                description = String.format("force-with-lease push %s to %s was rejected", sourceBranch, targetBranch);
                break;
            }
            case REJECTED_OTHER: {
                description = String.format("push %s to %s was rejected by remote", sourceBranch, targetBranch);
                break;
            }
            case ERROR: {
                description = result2.getError();
                break;
            }
            default: {
                LOG.error("Unexpected push result: " + result2);
                description = "";
            }
        }
        return description;
    }

    @Nullable
    private static String formTagDescription(@NotNull List<String> pushedTags, @NotNull String remoteName) {
        if (pushedTags.isEmpty()) {
            return null;
        }
        if (pushedTags.size() == 1) {
            return "tag " + GitBranchUtil.stripRefsPrefix(pushedTags.get(0)) + " to " + remoteName;
        }
        return pushedTags.size() + " tags to " + remoteName;
    }

    private static String formDescriptionBasedOnUpdateResult(GitUpdateResult updateResult, String targetBranch) {
        if (updateResult == null || updateResult == GitUpdateResult.SUCCESS || updateResult == GitUpdateResult.NOTHING_TO_UPDATE) {
            return String.format("push to %s was rejected", targetBranch);
        }
        if (updateResult == GitUpdateResult.SUCCESS_WITH_RESOLVED_CONFLICTS) {
            return UPDATE_WITH_RESOLVED_CONFLICTS;
        }
        if (updateResult == GitUpdateResult.INCOMPLETE) {
            return INCOMPLETE_UPDATE;
        }
        if (updateResult == GitUpdateResult.CANCEL) {
            return UPDATE_CANCELLED;
        }
        return UPDATE_WITH_ERRORS;
    }

    private static class ForcePushNotificationAction
    extends NotificationAction {
        @NotNull
        private final Project myProject;
        @NotNull
        private final GitPushOperation myOperation;
        @NotNull
        private final List<GitRepository> myRepositories;

        private ForcePushNotificationAction(@NotNull Project project, @NotNull GitPushOperation pushOperation, @NotNull List<GitRepository> repositories) {
            super("Force Push Anyway");
            this.myProject = project;
            this.myOperation = pushOperation;
            this.myRepositories = repositories;
        }

        public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
            notification.expire();
            final Project project = this.myProject;
            new Task.Backgroundable(project, "Pushing...", true){

                public void run(@NotNull ProgressIndicator indicator) {
                    GitPushOperation forcePushOperation = myOperation.deriveForceWithoutLease(myRepositories);
                    GitPusher.pushAndNotify(project, forcePushOperation);
                }
            }.queue();
        }
    }
}

