/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.annotate.ShowAllAffectedGenericAction;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.DiffFromHistoryHandler;
import com.intellij.openapi.vcs.history.HistoryAsTreeProvider;
import com.intellij.openapi.vcs.history.VcsAbstractHistorySession;
import com.intellij.openapi.vcs.history.VcsAppendableHistorySessionPartner;
import com.intellij.openapi.vcs.history.VcsBaseRevisionAdviser;
import com.intellij.openapi.vcs.history.VcsCacheableHistorySessionFactory;
import com.intellij.openapi.vcs.history.VcsDependentHistoryComponents;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.vcs.history.VcsHistoryProviderEx;
import git4idea.GitContentRevision;
import git4idea.GitFileRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitObjectType;
import git4idea.history.GitDiffFromHistoryHandler;
import git4idea.history.GitFileHistory;
import git4idea.history.GitHistoryNotificationPanel;
import git4idea.history.GitHistoryUtils;
import git4idea.log.GitShowCommitInLogAction;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class GitHistoryProvider
implements VcsHistoryProviderEx,
VcsCacheableHistorySessionFactory<Boolean, VcsAbstractHistorySession>,
VcsBaseRevisionAdviser {
    private static final Logger LOG = Logger.getInstance((String)GitHistoryProvider.class.getName());
    @NotNull
    private final Project myProject;

    public GitHistoryProvider(@NotNull Project project) {
        this.myProject = project;
    }

    public VcsDependentHistoryComponents getUICustomization(VcsHistorySession session, JComponent forShortcutRegistration) {
        return new VcsDependentHistoryComponents(ColumnInfo.EMPTY_ARRAY, null, null, GitHistoryNotificationPanel.create(this.myProject, session));
    }

    public AnAction[] getAdditionalActions(Runnable refresher) {
        return new AnAction[]{ShowAllAffectedGenericAction.getInstance(), ActionManager.getInstance().getAction("Vcs.CopyRevisionNumberAction"), new GitShowCommitInLogAction()};
    }

    public boolean isDateOmittable() {
        return false;
    }

    @Nullable
    public String getHelpId() {
        return null;
    }

    public VcsAbstractHistorySession createFromCachedData(Boolean aBoolean, @NotNull List<? extends VcsFileRevision> revisions, @NotNull FilePath filePath, VcsRevisionNumber currentRevision) {
        return this.createSession(filePath, revisions, currentRevision);
    }

    @Nullable
    public VcsAbstractHistorySession createSessionFor(FilePath filePath) throws VcsException {
        List<VcsFileRevision> revisions;
        return this.createSession(filePath, revisions, (revisions = GitFileHistory.collectHistory(this.myProject, filePath, new String[0])).isEmpty() ? null : ((VcsFileRevision)ContainerUtil.getFirstItem(revisions)).getRevisionNumber());
    }

    private VcsAbstractHistorySession createSession(FilePath filePath, List<? extends VcsFileRevision> revisions, @Nullable VcsRevisionNumber number) {
        return new GitHistorySession(filePath, number, revisions);
    }

    @Nullable
    public VcsFileRevision getLastRevision(FilePath filePath) throws VcsException {
        List<VcsFileRevision> history = GitFileHistory.collectHistory(this.myProject, filePath, "--max-count=1");
        if (history.isEmpty()) {
            return null;
        }
        return history.get(0);
    }

    public boolean getBaseVersionContent(FilePath filePath, Processor<? super String> processor, String beforeVersionId) throws VcsException {
        if (StringUtil.isEmptyOrSpaces((String)beforeVersionId) || filePath.getVirtualFile() == null) {
            return false;
        }
        GitRepository repository = (GitRepository)GitRepositoryManager.getInstance(this.myProject).getRepositoryForFile(filePath);
        if (repository == null) {
            return false;
        }
        GitObjectType objectType = Git.getInstance().getObjectTypeEnum(repository, beforeVersionId);
        if (!GitObjectType.COMMIT.equals((Object)objectType)) {
            return false;
        }
        ContentRevision content = GitContentRevision.createRevision(filePath, (VcsRevisionNumber)new GitRevisionNumber(beforeVersionId), this.myProject);
        return !processor.process((Object)content.getContent());
    }

    public void reportAppendableHistory(FilePath path, VcsAppendableHistorySessionPartner partner) {
        this.reportAppendableHistory(path, null, partner);
    }

    public void reportAppendableHistory(@NotNull FilePath path, @Nullable VcsRevisionNumber startingRevision, @NotNull VcsAppendableHistorySessionPartner partner) {
        String[] stringArray;
        VcsAbstractHistorySession emptySession = this.createSession(path, Collections.emptyList(), null);
        partner.reportCreatedEmptySession(emptySession);
        VcsConfiguration vcsConfiguration = VcsConfiguration.getInstance((Project)this.myProject);
        if (vcsConfiguration.LIMIT_HISTORY) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "--max-count=" + vcsConfiguration.MAXIMUM_HISTORY_ROWS;
        } else {
            stringArray = ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        String[] additionalArgs = stringArray;
        GitFileHistory.loadHistory(this.myProject, path, startingRevision, (Consumer<? super GitFileRevision>)((Consumer)fileRevision -> partner.acceptRevision((VcsFileRevision)fileRevision)), (Consumer<? super VcsException>)((Consumer)exception -> partner.reportException(exception)), additionalArgs);
    }

    public boolean supportsHistoryForDirectories() {
        return true;
    }

    public DiffFromHistoryHandler getHistoryDiffHandler() {
        return new GitDiffFromHistoryHandler(this.myProject);
    }

    public boolean canShowHistoryFor(@NotNull VirtualFile file) {
        GitRepositoryManager manager = GitUtil.getRepositoryManager(this.myProject);
        GitRepository repository = (GitRepository)manager.getRepositoryForFileQuick(file);
        return repository != null && !repository.isFresh();
    }

    class GitHistorySession
    extends VcsAbstractHistorySession {
        @NotNull
        private final FilePath myFilePath;

        GitHistorySession(@Nullable FilePath filePath, @NotNull VcsRevisionNumber number, List<? extends VcsFileRevision> revisions) {
            super(revisions, number);
            this.myFilePath = filePath;
        }

        @Nullable
        protected VcsRevisionNumber calcCurrentRevisionNumber() {
            try {
                return GitHistoryUtils.getCurrentRevision(GitHistoryProvider.this.myProject, this.myFilePath, "HEAD");
            }
            catch (VcsException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Unable to retrieve the current revision number", (Throwable)e);
                }
                return null;
            }
        }

        public HistoryAsTreeProvider getHistoryAsTreeProvider() {
            return null;
        }

        public VcsHistorySession copy() {
            return GitHistoryProvider.this.createSession(this.myFilePath, this.getRevisionList(), this.getCurrentRevisionNumber());
        }

        @NotNull
        FilePath getFilePath() {
            return this.myFilePath;
        }
    }
}

