/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import git4idea.config.ErrorNotifier;
import git4idea.config.GitDownloadAndInstallKt;
import git4idea.config.GitExecutableProblemHandler;
import git4idea.config.GitExecutableProblemHandlersKt;
import git4idea.config.GitInstaller;
import git4idea.config.GitVersionIdentificationException;
import git4idea.config.MacExecutableProblemHandler;
import git4idea.i18n.GitBundle;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 -2\u00020\u0001:\u0001-B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J.\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00110\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J$\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\f0\u001fH\u0002J\u0010\u0010 \u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J&\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\f2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00110\u0018H\u0002J \u0010&\u001a\u00020\f2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\fH\u0002J\u0010\u0010'\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010(\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J&\u0010)\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00110\u0018H\u0016J&\u0010*\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00110\u0018H\u0002J\u0010\u0010+\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010,\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\t\u001a\u00070\u0006\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lgit4idea/config/MacExecutableProblemHandler;", "Lgit4idea/config/GitExecutableProblemHandler;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "mountPoint", "Ljava/io/File;", "getProject", "()Lcom/intellij/openapi/project/Project;", "tempPath", "Lorg/jetbrains/annotations/NotNull;", "attachVolume", "", "file", "errorNotifier", "Lgit4idea/config/ErrorNotifier;", "detachVolume", "", "execXCodeSelectInstall", "installGit", "dmgFile", "pkgFileName", "", "onErrorResolved", "Lkotlin/Function0;", "installPackageOrShowError", "isInvalidActiveDeveloperPath", "exception", "", "isXcodeError", "messageIndicator", "Lkotlin/Function1;", "isXcodeLicenseError", "runCommand", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "sudo", "onError", "runOrShowError", "showCouldntInstallError", "showCouldntStartInstallerError", "showError", "showGenericError", "showInvalidActiveDeveloperPathError", "showXCodeLicenseError", "Companion", "intellij.vcs.git"})
public final class MacExecutableProblemHandler
implements GitExecutableProblemHandler {
    private final File tempPath;
    private final File mountPoint;
    @NotNull
    private final Project project;
    @NotNull
    private static final Logger LOG;
    public static final Companion Companion;

    @Override
    public void showError(@NotNull Throwable exception, @NotNull ErrorNotifier errorNotifier, @NotNull Function0<Unit> onErrorResolved) {
        if (this.isXcodeLicenseError(exception)) {
            this.showXCodeLicenseError(errorNotifier);
        } else if (this.isInvalidActiveDeveloperPath(exception)) {
            this.showInvalidActiveDeveloperPathError(errorNotifier);
        } else {
            this.showGenericError(exception, errorNotifier, onErrorResolved);
        }
    }

    private final void showGenericError(Throwable exception, ErrorNotifier errorNotifier, Function0<Unit> onErrorResolved) {
        errorNotifier.showError(GitBundle.message("executable.error.git.not.installed", new Object[0]), GitExecutableProblemHandlersKt.getHumanReadableErrorFor(exception), new ErrorNotifier.FixOption.Standard(GitBundle.message("install.download.and.install.action", new Object[0]), (Function0<Unit>)((Function0)new Function0<Unit>(this, errorNotifier, onErrorResolved){
            final /* synthetic */ MacExecutableProblemHandler this$0;
            final /* synthetic */ ErrorNotifier $errorNotifier;
            final /* synthetic */ Function0 $onErrorResolved;

            public final void invoke() {
                this.$errorNotifier.executeTask(GitBundle.message("install.downloading.progress", new Object[0]), false, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ showGenericError.1 this$0;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final void invoke() {
                        try {
                            GitInstaller installer2 = GitDownloadAndInstallKt.fetchInstaller(this.this$0.$errorNotifier, (Function1<? super GitInstaller, Boolean>)((Function1)showGenericError.installer.1.INSTANCE));
                            if (installer2 != null) {
                                String fileName = installer2.getFileName();
                                File dmgFile = new File(MacExecutableProblemHandler.access$getTempPath$p(this.this$0.this$0), fileName);
                                String string = installer2.getPkgFileName();
                                if (string == null) {
                                    Intrinsics.throwNpe();
                                }
                                String pkgFileName = string;
                                if (GitDownloadAndInstallKt.downloadGit(installer2, dmgFile, this.this$0.this$0.getProject(), this.this$0.$errorNotifier)) {
                                    this.this$0.$errorNotifier.changeProgressTitle(GitBundle.message("install.installing.progress", new Object[0]));
                                    MacExecutableProblemHandler.access$installGit(this.this$0.this$0, dmgFile, pkgFileName, this.this$0.$errorNotifier, this.this$0.$onErrorResolved);
                                }
                            }
                        }
                        finally {
                            FileUtil.delete((File)MacExecutableProblemHandler.access$getTempPath$p(this.this$0.this$0));
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }));
            }
            {
                this.this$0 = macExecutableProblemHandler;
                this.$errorNotifier = errorNotifier;
                this.$onErrorResolved = function0;
                super(0);
            }
        })));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void installGit(File dmgFile, String pkgFileName, ErrorNotifier errorNotifier, Function0<Unit> onErrorResolved) {
        if (this.attachVolume(dmgFile, errorNotifier)) {
            try {
                if (this.installPackageOrShowError(pkgFileName, errorNotifier)) {
                    errorNotifier.showMessage(GitBundle.message("install.success.message", new Object[0]));
                    onErrorResolved.invoke();
                    errorNotifier.resetGitExecutable();
                }
            }
            finally {
                this.detachVolume();
            }
        }
    }

    private final boolean attachVolume(File file, ErrorNotifier errorNotifier) {
        GeneralCommandLine cmd = new GeneralCommandLine(new String[]{"hdiutil", "attach", "-readonly", "-noautoopen", "-noautofsck", "-nobrowse", "-mountpoint", this.mountPoint.getPath(), file.getPath()});
        return this.runOrShowError(cmd, errorNotifier, false);
    }

    private final boolean installPackageOrShowError(String pkgFileName, ErrorNotifier errorNotifier) {
        return this.runOrShowError(new GeneralCommandLine(new String[]{"installer", "-package", this.mountPoint + '/' + pkgFileName, "-target", "/"}), errorNotifier, true);
    }

    private final void detachVolume() {
        this.runCommand(new GeneralCommandLine(new String[]{"hdiutil", "detach", this.mountPoint.getPath()}), false, (Function0<Unit>)((Function0)detachVolume.1.INSTANCE));
    }

    private final boolean runOrShowError(GeneralCommandLine commandLine, ErrorNotifier errorNotifier, boolean sudo) {
        return this.runCommand(commandLine, sudo, (Function0<Unit>)((Function0)new Function0<Unit>(this, errorNotifier){
            final /* synthetic */ MacExecutableProblemHandler this$0;
            final /* synthetic */ ErrorNotifier $errorNotifier;

            public final void invoke() {
                MacExecutableProblemHandler.access$showCouldntInstallError(this.this$0, this.$errorNotifier);
            }
            {
                this.this$0 = macExecutableProblemHandler;
                this.$errorNotifier = errorNotifier;
                super(0);
            }
        }));
    }

    private final boolean runCommand(GeneralCommandLine commandLine, boolean sudo, Function0<Unit> onError) {
        try {
            GeneralCommandLine cmd = sudo ? ExecUtil.sudoCommand((GeneralCommandLine)commandLine, (String)"Install Git") : commandLine;
            ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)cmd);
            if (output.checkSuccess(LOG)) {
                return true;
            }
            LOG.warn(output.getStderr());
            onError.invoke();
            return false;
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            onError.invoke();
            return false;
        }
    }

    private final void showCouldntInstallError(ErrorNotifier errorNotifier) {
        errorNotifier.showError(GitBundle.message("install.general.error", new Object[0]), GitExecutableProblemHandlersKt.getLinkToConfigure(this.project));
    }

    private final void showCouldntStartInstallerError(ErrorNotifier errorNotifier) {
        errorNotifier.showError(GitBundle.message("install.mac.error.couldnt.start.command.line.tools", new Object[0]), GitExecutableProblemHandlersKt.getLinkToConfigure(this.project));
    }

    private final void showXCodeLicenseError(ErrorNotifier errorNotifier) {
        errorNotifier.showError(GitBundle.getString("git.executable.validation.error.xcode.title"), GitBundle.getString("git.executable.validation.error.xcode.message"), GitExecutableProblemHandlersKt.getLinkToConfigure(this.project));
    }

    private final void showInvalidActiveDeveloperPathError(ErrorNotifier errorNotifier) {
        ErrorNotifier.FixOption.Standard fixPathOption2 = new ErrorNotifier.FixOption.Standard(GitBundle.message("executable.mac.fix.path.action", new Object[0]), (Function0<Unit>)((Function0)new Function0<Unit>(this, errorNotifier){
            final /* synthetic */ MacExecutableProblemHandler this$0;
            final /* synthetic */ ErrorNotifier $errorNotifier;

            public final void invoke() {
                this.$errorNotifier.executeTask(GitBundle.message("install.mac.requesting.command.line.tools", new Object[0]) + "\u2026", false, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ showInvalidActiveDeveloperPathError.fixPathOption.1 this$0;

                    public final void invoke() {
                        MacExecutableProblemHandler.access$execXCodeSelectInstall(this.this$0.this$0, this.this$0.$errorNotifier);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }));
            }
            {
                this.this$0 = macExecutableProblemHandler;
                this.$errorNotifier = errorNotifier;
                super(0);
            }
        }));
        errorNotifier.showError(GitBundle.message("executable.mac.error.invalid.path.to.command.line.tools", new Object[0]), fixPathOption2);
    }

    private final boolean isXcodeLicenseError(Throwable exception) {
        return this.isXcodeError(exception, (Function1<? super String, Boolean>)((Function1)isXcodeLicenseError.1.INSTANCE));
    }

    private final boolean isInvalidActiveDeveloperPath(Throwable exception) {
        return this.isXcodeError(exception, (Function1<? super String, Boolean>)((Function1)isInvalidActiveDeveloperPath.1.INSTANCE));
    }

    private final boolean isXcodeError(Throwable exception, Function1<? super String, Boolean> messageIndicator) {
        String string;
        if (exception instanceof GitVersionIdentificationException) {
            Throwable throwable = exception.getCause();
            string = throwable != null ? throwable.getMessage() : null;
        } else {
            string = exception.getMessage();
        }
        String message = string;
        return message != null && (Boolean)messageIndicator.invoke((Object)message) != false;
    }

    private final void execXCodeSelectInstall(ErrorNotifier errorNotifier) {
        try {
            GeneralCommandLine cmd = new GeneralCommandLine(new String[]{"xcode-select", "--install"});
            ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)cmd);
            errorNotifier.hideProgress();
            if (!output.checkSuccess(LOG)) {
                LOG.warn(output.getStderr());
                this.showCouldntStartInstallerError(errorNotifier);
            } else {
                errorNotifier.resetGitExecutable();
            }
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            this.showCouldntStartInstallerError(errorNotifier);
        }
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public MacExecutableProblemHandler(@NotNull Project project) {
        this.project = project;
        this.tempPath = FileUtil.createTempDirectory((String)"git-install", null);
        this.mountPoint = new File(this.tempPath, "mount");
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        LOG = Logger.getInstance(MacExecutableProblemHandler.class);
    }

    @Override
    public void showError(@NotNull Throwable exception, @NotNull ErrorNotifier errorNotifier) {
        GitExecutableProblemHandler.DefaultImpls.showError(this, exception, errorNotifier);
    }

    public static final /* synthetic */ File access$getTempPath$p(MacExecutableProblemHandler $this) {
        return $this.tempPath;
    }

    public static final /* synthetic */ void access$installGit(MacExecutableProblemHandler $this, File dmgFile, String pkgFileName, ErrorNotifier errorNotifier, Function0 onErrorResolved) {
        $this.installGit(dmgFile, pkgFileName, errorNotifier, (Function0<Unit>)onErrorResolved);
    }

    public static final /* synthetic */ void access$showCouldntInstallError(MacExecutableProblemHandler $this, ErrorNotifier errorNotifier) {
        $this.showCouldntInstallError(errorNotifier);
    }

    public static final /* synthetic */ void access$execXCodeSelectInstall(MacExecutableProblemHandler $this, ErrorNotifier errorNotifier) {
        $this.execXCodeSelectInstall(errorNotifier);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lgit4idea/config/MacExecutableProblemHandler$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.vcs.git"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

