/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkin;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.vcs.FilePath;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public abstract class GitCheckinExplicitMovementProvider {
    public static final ExtensionPointName<GitCheckinExplicitMovementProvider> EP_NAME = ExtensionPointName.create((String)"Git4Idea.GitCheckinExplicitMovementProvider");

    public abstract boolean isEnabled(@NotNull Project var1);

    @NotNull
    public abstract String getDescription();

    @NotNull
    public abstract String getCommitMessage(@NotNull String var1);

    @NotNull
    public abstract Collection<Movement> collectExplicitMovements(@NotNull Project var1, @NotNull List<FilePath> var2, @NotNull List<FilePath> var3);

    public void afterMovementsCommitted(@NotNull Project project, @NotNull List<Couple<FilePath>> movedPaths) {
    }

    public static class Movement {
        @NotNull
        private final FilePath myBeforePath;
        @NotNull
        private final FilePath myAfterPath;

        public Movement(@NotNull FilePath beforePath, @NotNull FilePath afterPath) {
            this.myBeforePath = beforePath;
            this.myAfterPath = afterPath;
        }

        @NotNull
        public FilePath getBefore() {
            return this.myBeforePath;
        }

        @NotNull
        public FilePath getAfter() {
            return this.myAfterPath;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Movement movement = (Movement)o;
            return Objects.equals(this.myBeforePath, movement.myBeforePath) && Objects.equals(this.myAfterPath, movement.myAfterPath);
        }

        public int hashCode() {
            return Objects.hash(this.myBeforePath, this.myAfterPath);
        }
    }
}

