/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.util.containers.MultiMap;
import git4idea.branch.GitBranchOperation;
import git4idea.branch.GitBranchUiHandler;
import git4idea.branch.GitDeleteBranchOperation;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitCompoundResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.i18n.GitBundle;
import git4idea.push.GitPushParamsImpl;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitMultiRootBranchConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitDeleteRemoteBranchOperation
extends GitBranchOperation {
    private final List<String> myBranchNames;

    GitDeleteRemoteBranchOperation(@NotNull Project project, @NotNull Git git, @NotNull GitBranchUiHandler handler, @NotNull List<? extends GitRepository> repositories, @NotNull List<String> names) {
        super(project, git, handler, repositories);
        this.myBranchNames = names;
    }

    @Override
    protected void execute() {
        Collection<GitRepository> repositories = this.getRepositories();
        ArrayList<String> allTrackingBranches = new ArrayList<String>();
        MultiMap branchToCommonTrackingBranches = new MultiMap();
        Ref decisionRef = Ref.create();
        for (String branchName : this.myBranchNames) {
            Collection<String> commonTrackingBranches = GitDeleteRemoteBranchOperation.getCommonTrackingBranches(branchName, repositories);
            for (GitRepository repository : repositories) {
                String currentBranch = repository.getCurrentBranchName();
                if (currentBranch == null) continue;
                commonTrackingBranches.remove(currentBranch);
            }
            allTrackingBranches.addAll(commonTrackingBranches);
            branchToCommonTrackingBranches.put((Object)branchName, commonTrackingBranches);
        }
        ApplicationManager.getApplication().invokeAndWait(() -> decisionRef.set((Object)this.myUiHandler.confirmRemoteBranchDeletion(this.myBranchNames, allTrackingBranches, repositories)));
        GitBranchUiHandler.DeleteRemoteBranchDecision decision = (GitBranchUiHandler.DeleteRemoteBranchDecision)((Object)decisionRef.get());
        if (decision == GitBranchUiHandler.DeleteRemoteBranchDecision.CANCEL) {
            return;
        }
        for (String branchName : this.myBranchNames) {
            boolean deletedSuccessfully = this.doDeleteRemote(branchName, repositories);
            if (!deletedSuccessfully) continue;
            final ArrayList<String> successfullyDeletedLocalBranches = new ArrayList<String>(1);
            if (decision == GitBranchUiHandler.DeleteRemoteBranchDecision.DELETE_WITH_TRACKING) {
                for (final String branch : branchToCommonTrackingBranches.get((Object)branchName)) {
                    this.getIndicator().setText(GitBundle.message("delete.remote.branch.operation.deleting.process", branch));
                    new GitDeleteBranchOperation(this.myProject, this.myGit, this.myUiHandler, repositories, branch){

                        @Override
                        protected void notifySuccess() {
                            successfullyDeletedLocalBranches.add(branch);
                        }
                    }.execute();
                }
            }
            this.notifySuccessfulDeletion(branchName, successfullyDeletedLocalBranches);
        }
    }

    @Override
    protected void rollback() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public String getSuccessMessage() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    protected String getRollbackProposal() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    protected String getOperationName() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    private static Collection<String> getCommonTrackingBranches(@NotNull String remoteBranch, @NotNull Collection<? extends GitRepository> repositories) {
        return new GitMultiRootBranchConfig(repositories).getCommonTrackingBranches(remoteBranch);
    }

    private boolean doDeleteRemote(@NotNull String branchName, @NotNull Collection<? extends GitRepository> repositories) {
        Couple<String> pair = GitDeleteRemoteBranchOperation.splitNameOfRemoteBranch(branchName);
        String remoteName = (String)pair.getFirst();
        String branch = (String)pair.getSecond();
        GitCompoundResult result2 = new GitCompoundResult(this.myProject);
        for (GitRepository gitRepository : repositories) {
            GitCommandResult res;
            GitRemote remote = GitDeleteRemoteBranchOperation.getRemoteByName(gitRepository, remoteName);
            if (remote == null) {
                String error = "Couldn't find remote by name: " + remoteName;
                LOG.error(error);
                res = GitCommandResult.error(error);
            } else {
                res = this.pushDeletion(gitRepository, remote, branch);
                if (!res.success() && GitDeleteRemoteBranchOperation.isAlreadyDeletedError(res.getErrorOutputAsJoinedString())) {
                    res = this.myGit.remotePrune(gitRepository, remote);
                }
            }
            result2.append(gitRepository, res);
            gitRepository.update();
        }
        if (!result2.totalSuccess()) {
            VcsNotifier.getInstance((Project)this.myProject).notifyError(GitBundle.message("delete.remote.branch.operation.failed.to.delete.remote.branch", branchName), result2.getErrorOutputWithReposIndication(), true);
        }
        return result2.totalSuccess();
    }

    private static boolean isAlreadyDeletedError(@NotNull String errorOutput) {
        return errorOutput.contains("remote ref does not exist");
    }

    private static Couple<String> splitNameOfRemoteBranch(String branchName) {
        int firstSlash = branchName.indexOf(47);
        String remoteName = firstSlash > -1 ? branchName.substring(0, firstSlash) : branchName;
        String remoteBranchName = branchName.substring(firstSlash + 1);
        return Couple.of((Object)remoteName, (Object)remoteBranchName);
    }

    @NotNull
    private GitCommandResult pushDeletion(@NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull String branchName) {
        return this.myGit.push(repository, new GitPushParamsImpl(remote, ":" + branchName, false, false, false, null, Collections.emptyList()), new GitLineHandlerListener[0]);
    }

    @Nullable
    private static GitRemote getRemoteByName(@NotNull GitRepository repository, @NotNull String remoteName) {
        for (GitRemote remote : repository.getRemotes()) {
            if (!remote.getName().equals(remoteName)) continue;
            return remote;
        }
        return null;
    }

    private void notifySuccessfulDeletion(@NotNull String remoteBranchName, @NotNull Collection<String> localBranches) {
        String message = "";
        if (!localBranches.isEmpty()) {
            message = GitBundle.message("delete.remote.branch.operation.also.deleted.local.branches", localBranches.size(), StringUtil.join(localBranches, (String)", "));
        }
        VcsNotifier.getInstance((Project)this.myProject).notifySuccess(GitBundle.message("delete.remote.branch.operation.deleted.remote.branch", remoteBranchName), message);
    }
}

