/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitReference;
import git4idea.GitRemoteBranch;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitBranchesCollection {
    @NotNull
    private final Map<GitLocalBranch, Hash> myLocalBranches;
    @NotNull
    private final Map<GitRemoteBranch, Hash> myRemoteBranches;

    public GitBranchesCollection(@NotNull Map<GitLocalBranch, Hash> localBranches, @NotNull Map<GitRemoteBranch, Hash> remoteBranches) {
        this.myRemoteBranches = remoteBranches;
        this.myLocalBranches = localBranches;
    }

    @NotNull
    public Collection<GitLocalBranch> getLocalBranches() {
        return Collections.unmodifiableCollection(this.myLocalBranches.keySet());
    }

    @NotNull
    public Collection<GitRemoteBranch> getRemoteBranches() {
        return Collections.unmodifiableCollection(this.myRemoteBranches.keySet());
    }

    @Nullable
    public Hash getHash(@NotNull GitBranch branch) {
        if (branch instanceof GitLocalBranch) {
            return this.myLocalBranches.get(branch);
        }
        if (branch instanceof GitRemoteBranch) {
            return this.myRemoteBranches.get(branch);
        }
        return null;
    }

    @NotNull
    public Collection<GitLocalBranch> findLocalBranchesByHash(@NotNull Hash hash) {
        return ContainerUtil.filter(this.myLocalBranches.keySet(), key -> this.myLocalBranches.get(key).equals(hash));
    }

    @NotNull
    public Collection<GitRemoteBranch> findRemoteBranchesByHash(@NotNull Hash hash) {
        return ContainerUtil.filter(this.myRemoteBranches.keySet(), key -> this.myRemoteBranches.get(key).equals(hash));
    }

    @Nullable
    public GitLocalBranch findLocalBranch(@NotNull String name) {
        GitLocalBranch branch = new GitLocalBranch(name);
        return this.myLocalBranches.containsKey(branch) ? branch : null;
    }

    @Nullable
    public GitRemoteBranch findRemoteBranch(@NotNull String name) {
        return GitBranchesCollection.findByName(this.myRemoteBranches.keySet(), name);
    }

    @Nullable
    public GitBranch findBranchByName(@NotNull String name) {
        return (GitBranch)ObjectUtils.chooseNotNull((Object)this.findLocalBranch(name), (Object)this.findRemoteBranch(name));
    }

    @Nullable
    private static <T extends GitBranch> T findByName(@NotNull Collection<T> branches2, @NotNull String name) {
        return (T)((GitBranch)ContainerUtil.find(branches2, branch -> GitReference.BRANCH_NAME_HASHING_STRATEGY.equals((Object)name, (Object)branch.getName())));
    }
}

