/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.configuration;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.theoryinpractice.testng.configuration.TestNGConfiguration;
import com.theoryinpractice.testng.configuration.TestNGConfigurationProducer;
import com.theoryinpractice.testng.model.TestType;
import com.theoryinpractice.testng.util.TestNGUtil;
import org.jetbrains.annotations.NotNull;

public class AbstractTestNGSuiteConfigurationProducer
extends TestNGConfigurationProducer {
    protected boolean setupConfigurationFromContext(@NotNull TestNGConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        PsiFile containingFile;
        PsiElement element = context.getPsiLocation();
        PsiFile psiFile = containingFile = element != null ? element.getContainingFile() : null;
        if (containingFile == null) {
            return false;
        }
        VirtualFile virtualFile = containingFile.getVirtualFile();
        if (virtualFile == null || !virtualFile.isValid()) {
            return false;
        }
        if (!TestNGUtil.isTestngSuiteFile(virtualFile)) {
            return false;
        }
        RunnerAndConfigurationSettings settings = this.cloneTemplateConfiguration(context);
        this.setupConfigurationModule(context, (ModuleBasedConfiguration)configuration);
        Module originalModule = ((JavaRunConfigurationModule)configuration.getConfigurationModule()).getModule();
        configuration.getPersistantData().SUITE_NAME = virtualFile.getPath();
        configuration.getPersistantData().TEST_OBJECT = TestType.SUITE.getType();
        configuration.restoreOriginalModule(originalModule);
        configuration.setGeneratedName();
        settings.setName(configuration.getName());
        sourceElement.set((Object)containingFile);
        return true;
    }

    protected boolean isApplicableTestType(String type, ConfigurationContext context) {
        return TestType.SUITE.getType().equals(type);
    }
}

