/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.util;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.util.AnnotationUtilEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubstitutedExpressionEvaluationHelper {
    private final PsiConstantEvaluationHelper myHelper;
    private final Configuration myConfiguration;

    public SubstitutedExpressionEvaluationHelper(Project project) {
        this.myHelper = JavaPsiFacade.getInstance((Project)project).getConstantEvaluationHelper();
        this.myConfiguration = Configuration.getInstance();
    }

    Object computeExpression(@NotNull PsiExpression e, @NotNull List<? super PsiExpression> uncomputables) {
        return this.computeExpression(e, this.myConfiguration.getAdvancedConfiguration().getDfaOption(), this.myConfiguration.getAdvancedConfiguration().isIncludeUncomputablesAsLiterals(), uncomputables);
    }

    public Object computeExpression(@NotNull PsiExpression e, final @NotNull Configuration.DfaOption dfaOption, final boolean includeUncomputablesAsLiterals, final @NotNull List<? super PsiExpression> uncomputables) {
        final ConcurrentHashMap map = new ConcurrentHashMap();
        return this.myHelper.computeExpression(e, false, new PsiConstantEvaluationHelper.AuxEvaluator(){

            @Nullable
            public Object computeExpression(@NotNull PsiExpression o, @NotNull PsiConstantEvaluationHelper.AuxEvaluator auxEvaluator) {
                PsiElement resolved;
                PsiType resolvedType = null;
                if (o instanceof PsiMethodCallExpression) {
                    Object substituted;
                    PsiType returnType;
                    PsiMethodCallExpression c = (PsiMethodCallExpression)o;
                    PsiMethod m = (PsiMethod)c.getMethodExpression().resolve();
                    PsiType psiType = returnType = m != null ? m.getReturnType() : null;
                    if (returnType != null && !PsiType.VOID.equals((Object)returnType) && (substituted = SubstitutedExpressionEvaluationHelper.this.calcSubstituted((PsiModifierListOwner)m)) != null) {
                        return substituted;
                    }
                    resolvedType = returnType;
                } else if (o instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)o).resolve()) instanceof PsiModifierListOwner) {
                    Object substituted = SubstitutedExpressionEvaluationHelper.this.calcSubstituted((PsiModifierListOwner)resolved);
                    if (substituted != null) {
                        return substituted;
                    }
                    if (resolved instanceof PsiVariable) {
                        List values;
                        PsiVariable psiVariable = (PsiVariable)resolved;
                        resolvedType = psiVariable.getType();
                        if (dfaOption == Configuration.DfaOption.ASSIGNMENTS) {
                            values = DfaPsiUtil.getVariableAssignmentsInFile((PsiVariable)psiVariable, (boolean)true, (PsiElement)o);
                        } else if (dfaOption == Configuration.DfaOption.DFA) {
                            values = DfaUtil.getVariableValues((PsiVariable)psiVariable, (PsiElement)o);
                        } else if (dfaOption == Configuration.DfaOption.RESOLVE) {
                            PsiExpression initializer = psiVariable.getInitializer();
                            values = ContainerUtil.createMaybeSingletonList((Object)initializer);
                        } else {
                            values = Collections.emptyList();
                        }
                        for (PsiExpression value : values) {
                            Object computedValue = auxEvaluator.computeExpression(value, (PsiConstantEvaluationHelper.AuxEvaluator)this);
                            if (computedValue == null) continue;
                            return computedValue;
                        }
                    }
                }
                uncomputables.add(o);
                if (includeUncomputablesAsLiterals) {
                    if (resolvedType != null && PsiType.DOUBLE.isAssignableFrom(resolvedType)) {
                        return 1;
                    }
                    final StringBuilder sb = new StringBuilder();
                    o.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                        public void visitElement(@NotNull PsiElement element) {
                            if (element instanceof PsiExpressionList) {
                                return;
                            }
                            if (element instanceof PsiIdentifier) {
                                if (sb.length() > 0) {
                                    sb.append(".");
                                }
                                sb.append(element.getText());
                            }
                            super.visitElement(element);
                        }
                    });
                    return sb.toString();
                }
                return null;
            }

            @NotNull
            public ConcurrentMap<PsiElement, Object> getCacheMap(boolean overflow) {
                return map;
            }
        });
    }

    @Nullable
    private Object calcSubstituted(PsiModifierListOwner owner) {
        Set substAnnos = (Set)this.myConfiguration.getAdvancedConfiguration().getSubstAnnotationPair().second;
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)owner, (Set)substAnnos);
        return annotation != null ? AnnotationUtilEx.calcAnnotationValue(annotation, "value") : null;
    }
}

