/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.util;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import org.intellij.plugins.intelliLang.IntelliLangBundle;
import org.intellij.plugins.intelliLang.util.AnnotationUtilEx;
import org.intellij.plugins.intelliLang.util.InitializerRequirement;
import org.intellij.plugins.intelliLang.util.PsiUtilEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotateFix
implements LocalQuickFix {
    private final String myAnnotationName;
    private final String myArgList;

    public AnnotateFix(String annotationClassname) {
        this(annotationClassname, null);
    }

    public AnnotateFix(String annotationClassname, @Nullable String argList) {
        this.myAnnotationName = annotationClassname;
        this.myArgList = argList;
    }

    @NotNull
    public String getFamilyName() {
        return IntelliLangBundle.message("annotate.fix.family.name", StringUtil.getShortName((String)this.myAnnotationName));
    }

    public static boolean canApplyOn(PsiModifierListOwner element) {
        return PsiUtilEx.isInSourceContent((PsiElement)element) && element.getModifierList() != null;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement element = descriptor.getPsiElement();
        if (!(element instanceof PsiModifierListOwner) && (element = AnnotationUtilEx.getAnnotatedElementFor(element, AnnotationUtilEx.LookupType.PREFER_DECLARATION)) == null) {
            return;
        }
        PsiModifierList modifierList = ((PsiModifierListOwner)element).getModifierList();
        if (modifierList == null) {
            return;
        }
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{element})) {
            return;
        }
        WriteAction.run(() -> {
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            try {
                String argList;
                PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass(this.myAnnotationName, modifierList.getResolveScope());
                InitializerRequirement requirement = InitializerRequirement.calcInitializerRequirement(psiClass);
                if (this.myArgList == null) {
                    switch (requirement) {
                        case VALUE_REQUIRED: 
                        case OTHER_REQUIRED: {
                            argList = "(\"\")";
                            break;
                        }
                        default: {
                            argList = "";
                            break;
                        }
                    }
                } else {
                    argList = this.myArgList;
                }
                PsiAnnotation annotation = factory.createAnnotationFromText("@" + this.myAnnotationName + argList, (PsiElement)modifierList);
                annotation = (PsiAnnotation)modifierList.addBefore((PsiElement)annotation, modifierList.getFirstChild());
                annotation = (PsiAnnotation)JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)annotation);
                PsiAnnotationParameterList list = annotation.getParameterList();
                if (requirement != InitializerRequirement.NONE_REQUIRED && this.myArgList == null) {
                    ((NavigationItem)list).navigate(true);
                }
            }
            catch (IncorrectOperationException e) {
                Logger.getInstance((String)this.getClass().getName()).error((Throwable)e);
            }
        });
    }
}

