/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.actions;

import com.intellij.codeInspection.export.ExportToHTMLDialog;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class GenerateCoverageReportAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = e.getProject();
        assert (project != null);
        CoverageDataManager coverageDataManager = CoverageDataManager.getInstance(project);
        CoverageSuitesBundle currentSuite = coverageDataManager.getCurrentSuitesBundle();
        CoverageEngine coverageEngine = currentSuite.getCoverageEngine();
        ExportToHTMLDialog dialog = coverageEngine.createGenerateReportDialog(project, dataContext, currentSuite);
        dialog.reset();
        if (!dialog.showAndGet()) {
            return;
        }
        dialog.apply();
        coverageEngine.generateReport(project, dataContext, currentSuite);
    }

    public void update(@NotNull AnActionEvent e) {
        CoverageEngine coverageEngine;
        CoverageSuitesBundle currentSuite;
        DataContext dataContext = e.getDataContext();
        Presentation presentation = e.getPresentation();
        presentation.setEnabledAndVisible(false);
        Project project = e.getProject();
        if (project != null && (currentSuite = CoverageDataManager.getInstance(project).getCurrentSuitesBundle()) != null && (coverageEngine = currentSuite.getCoverageEngine()).isReportGenerationAvailable(project, dataContext, currentSuite)) {
            presentation.setEnabledAndVisible(true);
        }
    }
}

