/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.psi.codeStyle;

import com.intellij.application.options.CodeStyleAbstractConfigurable;
import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.codeStyle.properties.CodeStyleFieldAccessor;
import com.intellij.application.options.codeStyle.properties.MagicIntegerConstAccessor;
import com.intellij.lang.Language;
import com.intellij.lang.properties.PropertiesLanguage;
import com.intellij.lang.properties.psi.codeStyle.PropertiesCodeStyleSettings;
import com.intellij.lang.properties.psi.codeStyle.PropertiesCodeStyleSettingsPanel;
import com.intellij.psi.codeStyle.CodeStyleConfigurable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import java.lang.reflect.Field;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PropertiesLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    PropertiesLanguageCodeStyleSettingsProvider() {
    }

    @NotNull
    public CodeStyleConfigurable createConfigurable(@NotNull CodeStyleSettings baseSettings, @NotNull CodeStyleSettings modelSettings) {
        return new CodeStyleAbstractConfigurable(baseSettings, modelSettings, "Properties Files"){

            public String getHelpTopic() {
                return "reference.settingsdialog.codestyle.properties";
            }

            protected CodeStyleAbstractPanel createPanel(CodeStyleSettings settings) {
                return new PropertiesCodeStyleSettingsPanel(settings);
            }
        };
    }

    @Nullable
    public CustomCodeStyleSettings createCustomSettings(CodeStyleSettings settings) {
        return new PropertiesCodeStyleSettings(settings);
    }

    @NotNull
    public Language getLanguage() {
        return PropertiesLanguage.INSTANCE;
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        consumer.showStandardOptions(new String[]{"ALIGN_GROUP_FIELD_DECLARATIONS"});
        consumer.showCustomOption(PropertiesCodeStyleSettings.class, "SPACES_AROUND_KEY_VALUE_DELIMITER", "Insert space around key-value delimiter", null, new Object[0]);
        consumer.showCustomOption(PropertiesCodeStyleSettings.class, "KEY_VALUE_DELIMITER_CODE", "Key-value delimiter", null, new Object[]{new String[]{"=", ":", "whitespace symbol"}, new int[]{0, 1, 2}});
        consumer.showCustomOption(PropertiesCodeStyleSettings.class, "KEEP_BLANK_LINES", "Keep blank lines", null, new Object[0]);
    }

    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        return "key1=value\nsome_key=some_value\n\n#commentaries\nlast.key=some text here";
    }

    @Nullable
    public CodeStyleFieldAccessor getAccessor(@NotNull Object codeStyleObject, @NotNull Field field) {
        if (codeStyleObject instanceof PropertiesCodeStyleSettings && "KEY_VALUE_DELIMITER_CODE".equals(field.getName())) {
            return new MagicIntegerConstAccessor(codeStyleObject, field, new int[]{0, 1, 2}, new String[]{"equals", "colon", "space"});
        }
        return super.getAccessor(codeStyleObject, field);
    }
}

