/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.codeInsight.generation.CommenterDataHolder;
import com.intellij.codeInsight.generation.SelfManagingCommenter;
import com.intellij.lang.CodeDocumentationAwareCommenter;
import com.intellij.lang.properties.parsing.PropertiesTokenTypes;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertiesCommenter
implements CodeDocumentationAwareCommenter,
SelfManagingCommenter<CommenterDataHolder> {
    public static final String HASH_COMMENT_PREFIX = "#";
    public static final String EXCLAMATION_COMMENT_PREFIX = "!";

    public String getLineCommentPrefix() {
        return HASH_COMMENT_PREFIX;
    }

    public String getBlockCommentPrefix() {
        return null;
    }

    public String getBlockCommentSuffix() {
        return null;
    }

    public String getCommentedBlockCommentPrefix() {
        return null;
    }

    public String getCommentedBlockCommentSuffix() {
        return null;
    }

    @Nullable
    public CommenterDataHolder createLineCommentingState(int startLine, int endLine, @NotNull Document document, @NotNull PsiFile file) {
        return null;
    }

    @Nullable
    public CommenterDataHolder createBlockCommentingState(int selectionStart, int selectionEnd, @NotNull Document document, @NotNull PsiFile file) {
        return null;
    }

    public void commentLine(int line, int offset, @NotNull Document document, @NotNull CommenterDataHolder data) {
        document.insertString(offset, (CharSequence)HASH_COMMENT_PREFIX);
    }

    public void uncommentLine(int line, int offset, @NotNull Document document, @NotNull CommenterDataHolder data) {
        document.deleteString(offset, offset + HASH_COMMENT_PREFIX.length());
    }

    public boolean isLineCommented(int line, int offset, @NotNull Document document, @NotNull CommenterDataHolder data) {
        return CharArrayUtil.regionMatches((CharSequence)document.getCharsSequence(), (int)offset, (CharSequence)HASH_COMMENT_PREFIX) || CharArrayUtil.regionMatches((CharSequence)document.getCharsSequence(), (int)offset, (CharSequence)EXCLAMATION_COMMENT_PREFIX);
    }

    @Nullable
    public String getCommentPrefix(int line, @NotNull Document document, @NotNull CommenterDataHolder data) {
        return HASH_COMMENT_PREFIX;
    }

    @Nullable
    public TextRange getBlockCommentRange(int selectionStart, int selectionEnd, @NotNull Document document, @NotNull CommenterDataHolder data) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public String getBlockCommentPrefix(int selectionStart, @NotNull Document document, @NotNull CommenterDataHolder data) {
        return this.getBlockCommentPrefix();
    }

    @Nullable
    public String getBlockCommentSuffix(int selectionEnd, @NotNull Document document, @NotNull CommenterDataHolder data) {
        return this.getBlockCommentSuffix();
    }

    public void uncommentBlockComment(int startOffset, int endOffset, Document document, CommenterDataHolder data) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public TextRange insertBlockComment(int startOffset, int endOffset, Document document, CommenterDataHolder data) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public IElementType getLineCommentTokenType() {
        return PropertiesTokenTypes.END_OF_LINE_COMMENT;
    }

    @Nullable
    public IElementType getBlockCommentTokenType() {
        return null;
    }

    @Nullable
    public IElementType getDocumentationCommentTokenType() {
        return null;
    }

    @Nullable
    public String getDocumentationCommentPrefix() {
        return null;
    }

    @Nullable
    public String getDocumentationCommentLinePrefix() {
        return null;
    }

    @Nullable
    public String getDocumentationCommentSuffix() {
        return null;
    }

    public boolean isDocumentationComment(PsiComment element) {
        return false;
    }
}

