/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk;

import com.android.tools.idea.apk.ApkDebuggingUsageTracker;
import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.ApkFileType;
import com.android.tools.idea.apk.ApkImportPathProperty;
import com.android.tools.idea.apk.ApkModuleFactory;
import com.android.tools.idea.apk.ApkModuleSetup;
import com.android.tools.idea.apk.ApkProjectFolder;
import com.android.tools.idea.apk.ApkSetupContext;
import com.android.tools.idea.apk.AsyncResult;
import com.android.tools.idea.apk.FileWatcherService;
import com.android.tools.idea.apk.issues.SetupIssueReporter;
import com.android.tools.idea.apk.reload.ApkReloader;
import com.android.tools.idea.apk.reload.Util;
import com.android.tools.idea.apk.setup.ProjectApkFileSetup;
import com.android.tools.idea.apk.setup.project.ProjectSdkSetup;
import com.android.tools.idea.gradle.project.importing.ProjectFolder;
import com.android.tools.idea.project.CustomProjectTypeImporter;
import com.android.tools.idea.util.FileExtensions;
import com.android.tools.idea.util.ToolWindows;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.ExceptionUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApkProjectImporter
extends CustomProjectTypeImporter {
    @NotNull
    private final ProjectFolder.Factory myProjectFolderFactory;
    @NotNull
    private final ApkProjectFolder myProjectFolder;
    @NotNull
    private final ProjectApkFileSetup myApkFileSetup;
    @NotNull
    private final ApkModuleFactory myApkModuleFactory;
    @NotNull
    private final ApkModuleSetup myApkModuleSetup;
    @NotNull
    private final ProjectSdkSetup myProjectSdkSetup;
    @NotNull
    private final FileOpener myFileOpener;

    public ApkProjectImporter() {
        this(new ProjectFolder.Factory(), new ApkProjectFolder(), new ProjectApkFileSetup(), new ApkModuleFactory(), new ApkModuleSetup(), new ProjectSdkSetup(), OpenFileAction::openFile);
    }

    @VisibleForTesting
    public ApkProjectImporter(@NotNull ProjectFolder.Factory projectFolderFactory, @NotNull ApkProjectFolder projectFolder, @NotNull ProjectApkFileSetup apkFileSetup, @NotNull ApkModuleFactory apkModuleFactory, @NotNull ApkModuleSetup apkModuleSetup, @NotNull ProjectSdkSetup projectSdkSetup, @NotNull FileOpener fileOpener) {
        this.myProjectFolderFactory = projectFolderFactory;
        this.myProjectFolder = projectFolder;
        this.myApkFileSetup = apkFileSetup;
        this.myApkModuleFactory = apkModuleFactory;
        this.myApkModuleSetup = apkModuleSetup;
        this.myProjectSdkSetup = projectSdkSetup;
        this.myFileOpener = fileOpener;
    }

    public boolean canImport(@NotNull VirtualFile file) {
        return FileTypeChooser.getKnownFileTypeOrAssociate((VirtualFile)file, null) instanceof ApkFileType;
    }

    @Nullable
    private static Project getProjectWithReloadableApk() {
        Project[] projects = ProjectManager.getInstance().getOpenProjects();
        List apkProjects = Arrays.stream(projects).filter(p -> Util.isApkProject(p)).collect(Collectors.toList());
        if (apkProjects.isEmpty()) {
            return null;
        }
        if (apkProjects.size() > 1) {
            return null;
        }
        return (Project)apkProjects.get(0);
    }

    public boolean reloadApk(final @NotNull VirtualFile newApkFile) {
        final Project project = ApkProjectImporter.getProjectWithReloadableApk();
        if (project == null) {
            return false;
        }
        final VirtualFile oldApkFile = LocalFileSystem.getInstance().findFileByPath(FileUtil.join((String[])new String[]{project.getBasePath(), project.getName() + ".apk"}));
        if (oldApkFile == null) {
            return false;
        }
        int result = Messages.showYesNoCancelDialog((Project)project, (String)("Would you like to update the APK in existing project " + project.getName() + " or create a new project?"), (String)"Select Project", (String)"Update existing project", (String)"Create new project", (String)"Cancel", (Icon)Messages.getQuestionIcon());
        if (result == 2) {
            return true;
        }
        if (result == 1) {
            return false;
        }
        ProgressManager.getInstance().run((Task)new Task.Modal(project, "Import New APK", false){

            public void run(@NotNull ProgressIndicator indicator) {
                ApkReloader reloader = new ApkReloader(project, indicator);
                reloader.reload(oldApkFile, newApkFile);
                EditorNotifications.getInstance((Project)project).updateNotifications(newApkFile);
            }
        });
        return true;
    }

    public void importFile(@NotNull VirtualFile newApkFile) {
        if (this.reloadApk(newApkFile)) {
            return;
        }
        try {
            VirtualFile projectRootFolder = this.myProjectFolder.getOrCreateNewProjectFolder(newApkFile);
            File projectRootFolderPath = VfsUtilCore.virtualToIoFile((VirtualFile)projectRootFolder);
            ProjectFolder projectFolder = this.myProjectFolderFactory.create(projectRootFolderPath);
            projectFolder.createIdeaProjectFolder();
            ProjectManager projectManager = ProjectManager.getInstance();
            Project newProject = projectManager.createProject(projectRootFolderPath.getName(), projectRootFolderPath.getPath());
            if (newProject == null) {
                throw new NullPointerException("Failed to create a new project");
            }
            this.setUpApkProjectAsynchronous(newProject, projectRootFolderPath, newApkFile);
        }
        catch (Throwable e) {
            ApkProjectImporter.showAndLogError(e);
        }
    }

    private void setUpApkProjectAsynchronous(@NotNull Project project, @NotNull File projectRootFolderPath, @NotNull VirtualFile inputApkFile) {
        AsyncResult<VirtualFile> callback = this.setUpApkFile(project, inputApkFile, project.getBaseDir());
        callback.doWhenDone(() -> {
            VirtualFile projectApkFile = (VirtualFile)callback.getResult();
            assert (projectApkFile != null);
            this.createAndSetupMainModule(project, projectApkFile, inputApkFile);
            PlatformProjectOpenProcessor.openExistingProject((Path)projectRootFolderPath.toPath(), (Path)projectRootFolderPath.toPath(), (OpenProjectTask)new OpenProjectTask(true, null, false, false, project, null, true, null, null, -1, -1, true, false, true, null, false, false, null, null, null));
        });
        callback.doWhenRejected(() -> {
            Throwable error = callback.getUnexpectedError();
            assert (error != null);
            ApkProjectImporter.showAndLogError(error);
        });
    }

    @NotNull
    private AsyncResult<VirtualFile> setUpApkFile(@NotNull Project project, final @NotNull VirtualFile apkFile, final @NotNull VirtualFile projectRootFolder) {
        final AsyncResult<VirtualFile> callback = new AsyncResult<VirtualFile>();
        Task.Modal task = new Task.Modal(project, "Set Up APK", false){

            public void run(@NotNull ProgressIndicator indicator) {
                indicator.setIndeterminate(true);
                try {
                    VirtualFile copy = ApkProjectImporter.this.setUpApkFile(apkFile, projectRootFolder, indicator);
                    if (copy != null) {
                        callback.setDone(copy);
                        return;
                    }
                    callback.setRejected(new FileNotFoundException("Failed to find APK file in the project"));
                }
                catch (Throwable error) {
                    callback.setRejected(error);
                }
            }
        };
        task.queue();
        return callback;
    }

    @Nullable
    private VirtualFile setUpApkFile(@NotNull VirtualFile apkFile, @NotNull VirtualFile projectRootFolder, @Nullable ProgressIndicator indicator) throws IOException, ExecutionException, InterruptedException {
        Path apkFilePath = VfsUtilCore.virtualToIoFile((VirtualFile)apkFile).toPath();
        Path destination = VfsUtilCore.virtualToIoFile((VirtualFile)projectRootFolder).toPath();
        Path copyPath = this.myApkFileSetup.setUpApk(apkFilePath, destination, indicator);
        return VfsUtil.findFileByIoFile((File)copyPath.toFile(), (boolean)true);
    }

    private void createAndSetupMainModule(@NotNull Project project, @NotNull VirtualFile apkFile, @NotNull VirtualFile inputApkFile) {
        this.myProjectSdkSetup.setUpProject(project);
        try {
            ApkSetupContext context = this.myApkModuleFactory.createApkModule(project, apkFile);
            boolean unitTestMode = ApplicationManager.getApplication().isUnitTestMode();
            if (!unitTestMode) {
                project.save();
            }
            ApkImportPathProperty.setPath(project, inputApkFile);
            ApkImportPathProperty.setTimestamp(project, inputApkFile);
            StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> {
                try {
                    this.myApkModuleSetup.setUpApkModule(project, context);
                    this.myFileOpener.openFile(context.getApkFile(), project);
                    ApkFacet facet = context.getApkFacet();
                    assert (facet != null);
                    ApkDebuggingUsageTracker.logEvent(facet, AndroidStudioEvent.EventKind.APK_DEBUG_IMPORT);
                    SetupIssueReporter.getInstance(project).reportSetupIssues(facet);
                    ((FileWatcherService)ServiceManager.getService((Project)project, FileWatcherService.class)).setApkPathToWatch(inputApkFile.getPath());
                }
                catch (Throwable e) {
                    ApkProjectImporter.showAndLogError(e);
                }
                if (!unitTestMode) {
                    ApplicationManager.getApplication().invokeLater(() -> ToolWindows.activateProjectView((Project)project));
                }
            });
        }
        catch (Throwable e) {
            ApkProjectImporter.showAndLogError(e);
        }
    }

    private static void showAndLogError(@NotNull Throwable e) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)e);
            return;
        }
        Messages.showErrorDialog((String)e.getMessage(), (String)"APK Import");
        ApkProjectImporter.getLog().error(e);
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(ApkProjectImporter.class);
    }

    @VisibleForTesting
    public void setUpApkProjectSynchronous(@NotNull Project project, @NotNull VirtualFile inputApkFile) throws InterruptedException, ExecutionException, IOException {
        VirtualFile projectApkFile = this.setUpApkFile(inputApkFile, project.getBaseDir(), null);
        assert (projectApkFile != null);
        this.createAndSetupMainModule(project, projectApkFile, inputApkFile);
        Path projectRootFolderPath = FileExtensions.toIoFile((VirtualFile)ProjectUtil.guessProjectDir((Project)project)).toPath();
        PlatformProjectOpenProcessor.openExistingProject((Path)projectRootFolderPath, (Path)projectRootFolderPath, (OpenProjectTask)new OpenProjectTask(true, null, false, false, project, null, true, null, null, -1, -1, true, false, true, null, false, false, null, null, null));
    }

    @VisibleForTesting
    public static interface FileOpener {
        public void openFile(@NotNull VirtualFile var1, @NotNull Project var2);
    }
}

