/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk;

import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.run.AndroidRunConfiguration;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class ApkDebugger {
    @NotNull
    private final Project myProject;
    @NotNull
    private final DumbService myDumbService;
    @NotNull
    private final ExecutionManager myExecutionManager;

    private ApkDebugger(@NotNull Project project) {
        this(project, DumbService.getInstance((Project)project), ExecutionManager.getInstance((Project)project));
    }

    @VisibleForTesting
    ApkDebugger(@NotNull Project project, @NotNull DumbService dumbService, @NotNull ExecutionManager executionManager) {
        this.myProject = project;
        this.myDumbService = dumbService;
        this.myExecutionManager = executionManager;
    }

    public void startDebugSession() {
        this.myDumbService.smartInvokeLater(this::doStartDebugSession);
    }

    private void doStartDebugSession() {
        RunnerAndConfigurationSettings settings = RunManagerEx.getInstanceEx((Project)this.myProject).getSelectedConfiguration();
        assert (settings != null);
        try {
            RunConfiguration configuration = settings.getConfiguration();
            assert (configuration instanceof AndroidRunConfiguration);
            settings.checkSettings();
            DefaultDebugExecutor executor = new DefaultDebugExecutor();
            ExecutionEnvironmentBuilder builder = ExecutionEnvironmentBuilder.create((Executor)executor, (RunnerAndConfigurationSettings)settings);
            this.myExecutionManager.restartRunProfile(builder.activeTarget().build());
        }
        catch (Throwable e) {
            this.showAndLog(e);
        }
    }

    private void showAndLog(@NotNull Throwable e) {
        String text = "Cannot start debugging session";
        String cause = e.getMessage();
        if (StringUtil.isNotEmpty((String)cause)) {
            text = text + ": " + cause;
        }
        AndroidNotification.getInstance((Project)this.myProject).showBalloon("APK Debugging", text, NotificationType.ERROR);
        Logger.getInstance(this.getClass()).warn(text, e);
    }

    public static class Factory {
        @NotNull
        public ApkDebugger createNew(@NotNull Project project) {
            return new ApkDebugger(project);
        }
    }
}

