/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.jvm.types.JvmPrimitiveTypeKind;
import com.intellij.lang.jvm.types.JvmType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayFactory;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiType
implements PsiAnnotationOwner,
Cloneable,
JvmType {
    public static final PsiPrimitiveType BYTE = new PsiPrimitiveType(JvmPrimitiveTypeKind.BYTE);
    public static final PsiPrimitiveType CHAR = new PsiPrimitiveType(JvmPrimitiveTypeKind.CHAR);
    public static final PsiPrimitiveType DOUBLE = new PsiPrimitiveType(JvmPrimitiveTypeKind.DOUBLE);
    public static final PsiPrimitiveType FLOAT = new PsiPrimitiveType(JvmPrimitiveTypeKind.FLOAT);
    public static final PsiPrimitiveType INT = new PsiPrimitiveType(JvmPrimitiveTypeKind.INT);
    public static final PsiPrimitiveType LONG = new PsiPrimitiveType(JvmPrimitiveTypeKind.LONG);
    public static final PsiPrimitiveType SHORT = new PsiPrimitiveType(JvmPrimitiveTypeKind.SHORT);
    public static final PsiPrimitiveType BOOLEAN = new PsiPrimitiveType(JvmPrimitiveTypeKind.BOOLEAN);
    public static final PsiPrimitiveType VOID = new PsiPrimitiveType(JvmPrimitiveTypeKind.VOID);
    public static final PsiPrimitiveType NULL = new PsiPrimitiveType(null);
    public static final PsiType[] EMPTY_ARRAY = new PsiType[0];
    public static final ArrayFactory<PsiType> ARRAY_FACTORY = count -> count == 0 ? EMPTY_ARRAY : new PsiType[count];
    private TypeAnnotationProvider myAnnotationProvider;

    public static PsiType @NotNull [] createArray(int count) {
        return (PsiType[])ARRAY_FACTORY.create(count);
    }

    protected PsiType(PsiAnnotation @NotNull [] annotations) {
        this(TypeAnnotationProvider.Static.create(annotations));
    }

    protected PsiType(@NotNull TypeAnnotationProvider annotations) {
        this.myAnnotationProvider = annotations;
    }

    @NotNull
    public PsiType annotate(@NotNull TypeAnnotationProvider provider) {
        if (provider == this.myAnnotationProvider) {
            return this;
        }
        try {
            PsiType copy = (PsiType)this.clone();
            copy.myAnnotationProvider = provider;
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public PsiArrayType createArrayType() {
        return new PsiArrayType(this);
    }

    @Deprecated
    @NotNull
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public PsiArrayType createArrayType(PsiAnnotation ... annotations) {
        return new PsiArrayType(this, annotations);
    }

    @NotNull
    public String getPresentableText(boolean annotated) {
        return this.getPresentableText();
    }

    @NotNull
    public abstract String getPresentableText();

    @NotNull
    public String getCanonicalText(boolean annotated) {
        return this.getCanonicalText();
    }

    @NotNull
    public abstract String getCanonicalText();

    @NotNull
    public String getInternalCanonicalText() {
        return this.getCanonicalText();
    }

    public abstract boolean isValid();

    @Contract(pure=true)
    public boolean isAssignableFrom(@NotNull PsiType type) {
        return TypeConversionUtil.isAssignable(this, type);
    }

    public boolean isConvertibleFrom(@NotNull PsiType type) {
        return TypeConversionUtil.areTypesConvertible(type, this);
    }

    public abstract boolean equalsToText(@NotNull String var1);

    @NotNull
    public static PsiClassType getTypeByName(@NotNull String qName, @NotNull Project project, @NotNull GlobalSearchScope resolveScope) {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory(project);
        return factory.createTypeByFQClassName(qName, resolveScope);
    }

    @NotNull
    public static PsiClassType getJavaLangObject(@NotNull PsiManager manager, @NotNull GlobalSearchScope resolveScope) {
        return PsiType.getTypeByName("java.lang.Object", manager.getProject(), resolveScope);
    }

    @NotNull
    public static PsiClassType getJavaLangClass(@NotNull PsiManager manager, @NotNull GlobalSearchScope resolveScope) {
        return PsiType.getTypeByName("java.lang.Class", manager.getProject(), resolveScope);
    }

    @NotNull
    public static PsiClassType getJavaLangThrowable(@NotNull PsiManager manager, @NotNull GlobalSearchScope resolveScope) {
        return PsiType.getTypeByName("java.lang.Throwable", manager.getProject(), resolveScope);
    }

    @NotNull
    public static PsiClassType getJavaLangString(@NotNull PsiManager manager, @NotNull GlobalSearchScope resolveScope) {
        return PsiType.getTypeByName("java.lang.String", manager.getProject(), resolveScope);
    }

    @NotNull
    public static PsiClassType getJavaLangError(@NotNull PsiManager manager, @NotNull GlobalSearchScope resolveScope) {
        return PsiType.getTypeByName("java.lang.Error", manager.getProject(), resolveScope);
    }

    @NotNull
    public static PsiClassType getJavaLangRuntimeException(@NotNull PsiManager manager, @NotNull GlobalSearchScope resolveScope) {
        return PsiType.getTypeByName("java.lang.RuntimeException", manager.getProject(), resolveScope);
    }

    public abstract <A> A accept(@NotNull PsiTypeVisitor<A> var1);

    public final int getArrayDimensions() {
        PsiType type = this;
        int dims = 0;
        while (type instanceof PsiArrayType) {
            ++dims;
            type = ((PsiArrayType)type).getComponentType();
        }
        return dims;
    }

    @NotNull
    public final PsiType getDeepComponentType() {
        PsiType type = this;
        while (type instanceof PsiArrayType) {
            type = ((PsiArrayType)type).getComponentType();
        }
        return type;
    }

    @Nullable
    public abstract GlobalSearchScope getResolveScope();

    public abstract PsiType @NotNull [] getSuperTypes();

    @NotNull
    public final TypeAnnotationProvider getAnnotationProvider() {
        return this.myAnnotationProvider;
    }

    @Override
    public PsiAnnotation @NotNull [] getAnnotations() {
        return this.myAnnotationProvider.getAnnotations();
    }

    @Override
    public PsiAnnotation findAnnotation(@NotNull String qualifiedName) {
        for (PsiAnnotation annotation : this.getAnnotations()) {
            if (!qualifiedName.equals(annotation.getQualifiedName())) continue;
            return annotation;
        }
        return null;
    }

    @Override
    @NotNull
    public PsiAnnotation addAnnotation(@NotNull String qualifiedName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PsiAnnotation @NotNull [] getApplicableAnnotations() {
        return this.getAnnotations();
    }

    public String toString() {
        return "PsiType:" + this.getPresentableText();
    }

    protected static abstract class Stub
    extends PsiType {
        protected Stub(PsiAnnotation @NotNull [] annotations) {
            super(annotations);
        }

        protected Stub(@NotNull TypeAnnotationProvider annotations) {
            super(annotations);
        }

        @Override
        @NotNull
        public final String getPresentableText() {
            return this.getPresentableText(false);
        }

        @Override
        @NotNull
        public abstract String getPresentableText(boolean var1);

        @Override
        @NotNull
        public final String getCanonicalText() {
            return this.getCanonicalText(false);
        }

        @Override
        @NotNull
        public abstract String getCanonicalText(boolean var1);
    }
}

